/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.platform.win32.helper;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.platform.win32.Advapi32;
import cool.scx.ffm.platform.win32.Win32Exception;
import cool.scx.ffm.type.mapper.IntMapper;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import java.util.TreeMap;

public final class Advapi32Helper {
    public static TreeMap<String, Object> registryGetValues(int root, String keyPath) {
        return Advapi32Helper.registryGetValues(root, keyPath, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, Object> registryGetValues(int root, String keyPath, int samDesiredExtra) {
        IntMapper phkKey = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegOpenKeyExA(root, keyPath, 0, 0x20019 | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            TreeMap<String, Object> treeMap = Advapi32Helper.registryGetValues(phkKey.getValue());
            return treeMap;
        }
        finally {
            rc = Advapi32.ADVAPI32.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static TreeMap<String, Object> registryGetValues(int hKey) {
        IntMapper lpcValues = new IntMapper();
        IntMapper lpcMaxValueNameLen = new IntMapper();
        IntMapper lpcMaxValueLen = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegQueryInfoKeyW(hKey, null, null, null, null, null, null, lpcValues, lpcMaxValueNameLen, lpcMaxValueLen, null, null);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        TreeMap<String, Object> keyValues = new TreeMap<String, Object>();
        char[] name = new char[lpcMaxValueNameLen.getValue() + 1];
        try (Arena arena = Arena.ofConfined();){
            block18: for (int i = 0; i < lpcValues.getValue(); ++i) {
                IntMapper lpcbData;
                IntMapper lpType;
                MemorySegment byteData = arena.allocate(lpcMaxValueLen.getValue());
                IntMapper lpcchValueName = new IntMapper(lpcMaxValueNameLen.getValue() + 1);
                rc = Advapi32.ADVAPI32.RegEnumValueW(hKey, i, name, lpcchValueName, null, lpType = new IntMapper(), byteData, lpcbData = new IntMapper(lpcMaxValueLen.getValue()));
                if (rc != 0) {
                    throw new Win32Exception(rc);
                }
                String nameString = FFMHelper.toString(name);
                if (lpcbData.getValue() == 0) {
                    switch (lpType.getValue()) {
                        case 3: {
                            keyValues.put(nameString, new byte[0]);
                            continue block18;
                        }
                        case 1: 
                        case 2: {
                            keyValues.put(nameString, new char[0]);
                            continue block18;
                        }
                        case 7: {
                            keyValues.put(nameString, new String[0]);
                            continue block18;
                        }
                        case 0: {
                            keyValues.put(nameString, null);
                            continue block18;
                        }
                        default: {
                            throw new RuntimeException("Unsupported empty type: " + lpType.getValue());
                        }
                    }
                }
                switch (lpType.getValue()) {
                    case 11: {
                        keyValues.put(nameString, byteData.get(ValueLayout.JAVA_LONG, 0L));
                        continue block18;
                    }
                    case 4: {
                        keyValues.put(nameString, byteData.get(ValueLayout.JAVA_INT, 0L));
                        continue block18;
                    }
                    case 1: 
                    case 2: {
                        keyValues.put(nameString, FFMHelper.toString(byteData.toArray(ValueLayout.JAVA_CHAR)));
                        continue block18;
                    }
                    case 3: {
                        keyValues.put(nameString, Arrays.copyOf(byteData.toArray(ValueLayout.JAVA_BYTE), lpcbData.getValue()));
                        continue block18;
                    }
                    case 7: {
                        keyValues.put(nameString, null);
                        continue block18;
                    }
                    default: {
                        throw new RuntimeException("Unsupported type: " + lpType.getValue());
                    }
                }
            }
        }
        return keyValues;
    }

    public static int registryGetIntValue(int root, String key, String value) {
        return Advapi32Helper.registryGetIntValue(root, key, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registryGetIntValue(int root, String key, String value, int samDesiredExtra) {
        IntMapper phkKey = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegOpenKeyExA(root, key, 0, 0x20019 | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            int n = Advapi32Helper.registryGetIntValue(phkKey.getValue(), value);
            return n;
        }
        finally {
            rc = Advapi32.ADVAPI32.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static int registryGetIntValue(int hKey, String value) {
        IntMapper lpType = new IntMapper();
        IntMapper lpcbData = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegQueryValueExA(hKey, value, 0, lpType, (IntMapper)null, lpcbData);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 4) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_DWORD");
        }
        IntMapper data = new IntMapper();
        rc = Advapi32.ADVAPI32.RegQueryValueExA(hKey, value, 0, lpType, data, lpcbData);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        return data.getValue();
    }

    public static void registrySetStringValue(int root, String keyPath, String name, String value) {
        Advapi32Helper.registrySetStringValue(root, keyPath, name, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetStringValue(int root, String keyPath, String name, String value, int samDesiredExtra) {
        IntMapper phkKey = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegOpenKeyExA(root, keyPath, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            Advapi32Helper.registrySetStringValue(phkKey.getValue(), name, value);
        }
        finally {
            rc = Advapi32.ADVAPI32.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static void registrySetStringValue(int hKey, String name, String value) {
        if (value == null) {
            value = "";
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment data = arena.allocateFrom(value);
            int rc = Advapi32.ADVAPI32.RegSetValueExA(hKey, name, 0, 1, data, (int)data.byteSize());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static void registrySetIntValue(int root, String keyPath, String name, int value) {
        Advapi32Helper.registrySetIntValue(root, keyPath, name, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetIntValue(int root, String keyPath, String name, int value, int samDesiredExtra) {
        IntMapper phkKey = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegOpenKeyExA(root, keyPath, 0, 0x2001F | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            Advapi32Helper.registrySetIntValue(phkKey.getValue(), name, value);
        }
        finally {
            rc = Advapi32.ADVAPI32.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static void registrySetIntValue(int hKey, String name, int value) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment data = arena.allocateFrom(ValueLayout.JAVA_INT, value);
            int rc = Advapi32.ADVAPI32.RegSetValueExA(hKey, name, 0, 4, data, 4);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static String registryGetStringValue(int root, String key, String value) {
        return Advapi32Helper.registryGetStringValue(root, key, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registryGetStringValue(int root, String key, String value, int samDesiredExtra) {
        IntMapper phkKey = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegOpenKeyExA(root, key, 0, 0x20019 | samDesiredExtra, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            String string = Advapi32Helper.registryGetStringValue(phkKey.getValue(), value);
            return string;
        }
        finally {
            rc = Advapi32.ADVAPI32.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    public static String registryGetStringValue(int hKey, String value) {
        IntMapper lpType = new IntMapper();
        IntMapper lpcbData = new IntMapper();
        int rc = Advapi32.ADVAPI32.RegQueryValueExA(hKey, value, 0, lpType, (MemorySegment)null, lpcbData);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        if (lpType.getValue() != 1 && lpType.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + lpType.getValue() + ", expected REG_SZ or REG_EXPAND_SZ");
        }
        if (lpcbData.getValue() == 0) {
            return "";
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment mem = arena.allocate(lpcbData.getValue());
            rc = Advapi32.ADVAPI32.RegQueryValueExA(hKey, value, 0, lpType, mem, lpcbData);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            String string = mem.getString(0L);
            return string;
        }
    }
}

