/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.paramter;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.callback.Callback;
import cool.scx.ffm.paramter.Parameter;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;

public class CallbackParameter
implements Parameter {
    private final Callback callback;
    private final MethodHandle fun;
    private final FunctionDescriptor functionDescriptor;

    public CallbackParameter(Callback callback) throws NoSuchMethodException, IllegalAccessException {
        this.callback = callback;
        String callbackMethodName = callback.callbackMethodName();
        Method method = Arrays.stream(callback.getClass().getMethods()).filter(m -> m.getName().equals(callbackMethodName)).findFirst().orElseThrow(() -> new NoSuchMethodException(callbackMethodName));
        method.setAccessible(true);
        this.fun = MethodHandles.lookup().unreflect(method).bindTo(callback);
        MemoryLayout r = FFMHelper.getMemoryLayout(method.getReturnType());
        MemoryLayout[] p = FFMHelper.getMemoryLayouts(method.getParameterTypes());
        this.functionDescriptor = FunctionDescriptor.of(r, p);
    }

    @Override
    public Object toNativeParameter(Arena arena) {
        return Linker.nativeLinker().upcallStub(this.fun, this.functionDescriptor, arena, new Linker.Option[0]);
    }
}

