/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.paramter;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.paramter.Parameter;
import cool.scx.ffm.struct.Struct;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class StructParameter
implements Parameter {
    private final Object value;
    private final Map<Field, VarHandle> fieldMap;
    private final StructLayout LAYOUT;
    private MemorySegment memorySegment;

    public StructParameter(Struct value) {
        this.value = value;
        Class<?> classInfo = this.value.getClass();
        this.fieldMap = new HashMap<Field, VarHandle>();
        Field[] fields = classInfo.getFields();
        MemoryLayout[] memoryLayouts = new MemoryLayout[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            MemoryLayout memoryLayout = FFMHelper.getMemoryLayout(f.getType());
            memoryLayouts[i] = memoryLayout.withName(f.getName());
        }
        this.LAYOUT = MemoryLayout.structLayout(memoryLayouts);
        for (Field f : fields) {
            VarHandle x = this.LAYOUT.varHandle(MemoryLayout.PathElement.groupElement(f.getName()));
            VarHandle ff = MethodHandles.insertCoordinates(x, 1, 0L);
            this.fieldMap.put(f, ff);
        }
    }

    @Override
    public Object toNativeParameter(Arena arena) {
        this.memorySegment = arena.allocate(this.LAYOUT);
        return this.memorySegment;
    }

    @Override
    public void beforeCloseArena() {
        for (Map.Entry<Field, VarHandle> e : this.fieldMap.entrySet()) {
            Field k = e.getKey();
            VarHandle v = e.getValue();
            Object o = v.get(this.memorySegment);
            try {
                k.set(this.value, o);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

