/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.mapper;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.mapper.Mapper;
import cool.scx.ffm.type.Callback;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ScxReflect;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;

public class CallbackMapper
implements Mapper {
    private final Callback callback;
    private final MethodHandle fun;
    private final FunctionDescriptor functionDescriptor;

    public CallbackMapper(Callback callback) throws NoSuchMethodException, IllegalAccessException {
        this.callback = callback;
        ClassInfo classInfo = (ClassInfo)ScxReflect.getType(callback.getClass());
        String callbackMethodName = callback.callbackMethodName();
        MethodInfo methodInfo = Arrays.stream(classInfo.methods()).filter(m -> m.name().equals(callbackMethodName)).findFirst().orElseThrow(() -> new NoSuchMethodException(callbackMethodName));
        methodInfo.setAccessible(true);
        Method method = methodInfo.rawMethod();
        this.fun = MethodHandles.lookup().unreflect(method).bindTo(callback);
        MemoryLayout r = FFMHelper.getMemoryLayout(method.getReturnType());
        MemoryLayout[] p = FFMHelper.getMemoryLayouts(method.getParameterTypes());
        this.functionDescriptor = FunctionDescriptor.of(r, p);
    }

    @Override
    public MemorySegment toMemorySegment(Arena arena) {
        return Linker.nativeLinker().upcallStub(this.fun, this.functionDescriptor, arena, new Linker.Option[0]);
    }

    @Override
    public void fromMemorySegment(MemorySegment memorySegment) {
    }
}

