/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm.mapper;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.mapper.Mapper;
import cool.scx.ffm.type.Struct;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ScxReflect;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructMapper
implements Mapper {
    private final Object value;
    private final Map<FieldInfo, VarHandle> fieldMap;
    private final StructLayout LAYOUT;

    public StructMapper(Struct value) {
        this.value = value;
        ClassInfo classInfo = (ClassInfo)ScxReflect.typeOf(this.value.getClass());
        this.fieldMap = new HashMap<FieldInfo, VarHandle>();
        List<FieldInfo> fields = Arrays.stream(classInfo.allFields()).filter(c -> c.accessModifier() == AccessModifier.PUBLIC && !c.isStatic()).toList();
        MemoryLayout[] memoryLayouts = new MemoryLayout[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo f = fields.get(i);
            MemoryLayout memoryLayout = FFMHelper.getMemoryLayout(f.rawField().getType());
            memoryLayouts[i] = memoryLayout.withName(f.name());
        }
        this.LAYOUT = MemoryLayout.structLayout(memoryLayouts);
        for (FieldInfo f : fields) {
            VarHandle x = this.LAYOUT.varHandle(MemoryLayout.PathElement.groupElement(f.name()));
            VarHandle ff = MethodHandles.insertCoordinates(x, 1, 0L);
            this.fieldMap.put(f, ff);
        }
    }

    @Override
    public MemorySegment toMemorySegment(Arena arena) {
        return arena.allocate(this.LAYOUT);
    }

    @Override
    public void fromMemorySegment(MemorySegment memorySegment) {
        for (Map.Entry<FieldInfo, VarHandle> e : this.fieldMap.entrySet()) {
            FieldInfo k = e.getKey();
            VarHandle v = e.getValue();
            Object o = v.get(memorySegment);
            try {
                k.set(this.value, o);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

