/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm;

import cool.scx.ffm.FFMHelper;
import cool.scx.ffm.mapper.Mapper;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class FFMProxy
implements InvocationHandler {
    private final SymbolLookup lookup;
    private final Map<Method, MethodHandle> cache;

    FFMProxy(SymbolLookup lookup) {
        this.lookup = lookup;
        this.cache = new HashMap<Method, MethodHandle>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        MethodHandle methodHandle = this.cache.computeIfAbsent(method, this::findMethodHandle);
        try (Arena arena = Arena.ofConfined();){
            Object[] parameters = FFMHelper.convertToParameters(args);
            Object[] nativeParameters = new Object[args.length];
            for (int i = 0; i < parameters.length; ++i) {
                Object parameter = parameters[i];
                if (parameter instanceof Mapper) {
                    Mapper mapper = (Mapper)parameter;
                    nativeParameters[i] = mapper.toMemorySegment(arena);
                    continue;
                }
                nativeParameters[i] = parameter;
            }
            Object result = methodHandle.invokeWithArguments(nativeParameters);
            for (int i = 0; i < parameters.length; ++i) {
                Object parameter = parameters[i];
                Object nativeParameter = nativeParameters[i];
                if (!(parameter instanceof Mapper)) continue;
                Mapper mapper = (Mapper)parameter;
                if (!(nativeParameter instanceof MemorySegment)) continue;
                MemorySegment memorySegment = (MemorySegment)nativeParameter;
                mapper.fromMemorySegment(memorySegment);
            }
            Object object = result;
            return object;
        }
    }

    private MethodHandle findMethodHandle(Method method) {
        MemorySegment fun = this.lookup.find(method.getName()).orElse(null);
        if (fun == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u5916\u90e8\u65b9\u6cd5 : " + method.getName());
        }
        MemoryLayout returnLayout = FFMHelper.getMemoryLayout(method.getReturnType());
        MemoryLayout[] paramLayouts = FFMHelper.getMemoryLayouts(method.getParameterTypes());
        FunctionDescriptor functionDescriptor = FunctionDescriptor.of(returnLayout, paramLayouts);
        return Linker.nativeLinker().downcallHandle(fun, functionDescriptor, new Linker.Option[0]);
    }
}

