/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ffm;

import cool.scx.ffm.mapper.ByteArrayMapper;
import cool.scx.ffm.mapper.CallbackMapper;
import cool.scx.ffm.mapper.CharArrayMapper;
import cool.scx.ffm.mapper.DoubleArrayMapper;
import cool.scx.ffm.mapper.FloatArrayMapper;
import cool.scx.ffm.mapper.IntArrayMapper;
import cool.scx.ffm.mapper.LongArrayMapper;
import cool.scx.ffm.mapper.Mapper;
import cool.scx.ffm.mapper.ShortArrayMapper;
import cool.scx.ffm.mapper.StringMapper;
import cool.scx.ffm.mapper.StructMapper;
import cool.scx.ffm.type.Callback;
import cool.scx.ffm.type.Struct;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.runtime.SwitchBootstraps;

public final class FFMHelper {
    public static MemoryLayout getMemoryLayout(Class<?> type) {
        if (type == Byte.class || type == Byte.TYPE) {
            return ValueLayout.JAVA_BYTE;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return ValueLayout.JAVA_BOOLEAN;
        }
        if (type == Character.class || type == Character.TYPE) {
            return ValueLayout.JAVA_CHAR;
        }
        if (type == Short.class || type == Short.TYPE) {
            return ValueLayout.JAVA_SHORT;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return ValueLayout.JAVA_INT;
        }
        if (type == Long.class || type == Long.TYPE) {
            return ValueLayout.JAVA_LONG;
        }
        if (type == Float.class || type == Float.TYPE) {
            return ValueLayout.JAVA_FLOAT;
        }
        if (type == Double.class || type == Double.TYPE) {
            return ValueLayout.JAVA_DOUBLE;
        }
        if (type == MemorySegment.class) {
            return ValueLayout.ADDRESS;
        }
        if (String.class == type) {
            return ValueLayout.ADDRESS;
        }
        if (Mapper.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (Struct.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (Callback.class.isAssignableFrom(type)) {
            return ValueLayout.ADDRESS;
        }
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            return ValueLayout.ADDRESS;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b !!! " + String.valueOf(type));
    }

    public static MemoryLayout[] getMemoryLayouts(Class<?>[] types) {
        MemoryLayout[] memoryLayouts = new MemoryLayout[types.length];
        for (int i = 0; i < types.length; ++i) {
            memoryLayouts[i] = FFMHelper.getMemoryLayout(types[i]);
        }
        return memoryLayouts;
    }

    public static Object convertToParameter(Object o) throws NoSuchMethodException, IllegalAccessException {
        Object object;
        Object object2 = o;
        int n = 0;
        block15: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class, MemorySegment.class, String.class, Mapper.class, Struct.class, Callback.class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
                case -1: {
                    object = MemorySegment.NULL;
                    break block15;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (!(object2 instanceof Byte || object2 instanceof Short || object2 instanceof Integer || object2 instanceof Long || object2 instanceof Float || object2 instanceof Double || object2 instanceof Boolean || object2 instanceof Character || object2 instanceof MemorySegment)) {
                        n = 9;
                        continue block15;
                    }
                    object = o;
                    break block15;
                }
                case 9: {
                    String s = (String)object2;
                    object = new StringMapper(s);
                    break block15;
                }
                case 10: {
                    Mapper m = (Mapper)object2;
                    object = m;
                    break block15;
                }
                case 11: {
                    Struct c = (Struct)object2;
                    object = new StructMapper(c);
                    break block15;
                }
                case 12: {
                    Callback c = (Callback)object2;
                    object = new CallbackMapper(c);
                    break block15;
                }
                case 13: {
                    byte[] c = (byte[])object2;
                    object = new ByteArrayMapper(c);
                    break block15;
                }
                case 14: {
                    char[] c = (char[])object2;
                    object = new CharArrayMapper(c);
                    break block15;
                }
                case 15: {
                    short[] c = (short[])object2;
                    object = new ShortArrayMapper(c);
                    break block15;
                }
                case 16: {
                    int[] c = (int[])object2;
                    object = new IntArrayMapper(c);
                    break block15;
                }
                case 17: {
                    long[] c = (long[])object2;
                    object = new LongArrayMapper(c);
                    break block15;
                }
                case 18: {
                    float[] c = (float[])object2;
                    object = new FloatArrayMapper(c);
                    break block15;
                }
                case 19: {
                    double[] c = (double[])object2;
                    object = new DoubleArrayMapper(c);
                    break block15;
                }
                default: {
                    throw new RuntimeException("\u65e0\u6cd5\u8f6c\u6362\u7684\u7c7b\u578b !!! " + String.valueOf(o.getClass()));
                }
            }
            break;
        }
        return object;
    }

    public static Object[] convertToParameters(Object[] objs) throws NoSuchMethodException, IllegalAccessException {
        if (objs == null) {
            return new Object[0];
        }
        Object[] result = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            result[i] = FFMHelper.convertToParameter(objs[i]);
        }
        return result;
    }

    public static String toString(char[] buf) {
        int len = buf.length;
        for (int index = 0; index < len; ++index) {
            if (buf[index] != '\u0000') continue;
            len = index;
            break;
        }
        return len == 0 ? "" : new String(buf, 0, len);
    }
}

