/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.helidon.HelidonHttpServer;
import cool.scx.http.helidon.HelidonServerWebSocket;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ReflectFactory;
import io.helidon.http.Header;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.PathMatchers;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.webserver.websocket.WsRouting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class HelidonHelper {
    HelidonHelper() {
    }

    public static WsRouting.Builder createHelidonWebSocketRouting(HelidonHttpServer server) {
        try {
            ClassInfo wsRouteClassInfo = ReflectFactory.getClassInfo(WsRoute.class);
            ConstructorInfo constructor = wsRouteClassInfo.constructors()[0];
            constructor.setAccessible(true);
            Object wsRoute = constructor.newInstance(new Object[]{PathMatchers.any(), () -> new HelidonServerWebSocket(server)});
            WsRouting.Builder builder = WsRouting.builder();
            ClassInfo classInfo = ReflectFactory.getClassInfo(WsRouting.Builder.class);
            MethodInfo routeMethod = Arrays.stream(classInfo.methods()).filter(method -> method.name().equals("route")).findFirst().orElseThrow();
            routeMethod.setAccessible(true);
            routeMethod.method().invoke((Object)builder, wsRoute);
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScxHttpHeadersWritable convertHeaders(Headers o) {
        ScxHttpHeadersWritable h = ScxHttpHeaders.of();
        for (Header header : o) {
            h.add(header.name(), header.allValues().toArray(new String[0]));
        }
        return h;
    }

    public static void updateHeaders(ScxHttpHeaders o, ServerResponseHeaders u) {
        u.clear();
        for (Map.Entry header : o) {
            u.add(HeaderNames.create((String)((ScxHttpHeaderName)header.getKey()).value()), (String[])((List)header.getValue()).toArray(String[]::new));
        }
    }
}

