/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ScxHttpServer;
import cool.scx.http.ScxHttpServerOptions;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.helidon.HelidonHelper;
import cool.scx.http.helidon.HelidonHttpRouting;
import io.helidon.common.Builder;
import io.helidon.common.tls.Tls;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.websocket.WsRouting;
import java.util.function.Consumer;

public class HelidonHttpServer
implements ScxHttpServer {
    private final WebServer webServer;
    Consumer<ScxHttpServerRequest> requestHandler;
    Consumer<ScxServerWebSocket> webSocketHandler;
    Consumer<Throwable> errorHandler;

    public HelidonHttpServer(ScxHttpServerOptions options) {
        HelidonHttpRouting httpRouting = new HelidonHttpRouting(this);
        WsRouting.Builder webSocketRouting = HelidonHelper.createHelidonWebSocketRouting(this);
        WebServerConfig.Builder builder = (WebServerConfig.Builder)((WebServerConfig.Builder)((WebServerConfig.Builder)((WebServerConfig.Builder)WebServer.builder().addRouting((Builder)httpRouting)).addRouting((Builder)webSocketRouting)).maxPayloadSize(options.getMaxPayloadSize())).port(options.getPort());
        if (options.getTLS() != null) {
            builder.tls((Tls)options.getTLS());
        }
        this.webServer = builder.build();
        this.requestHandler = null;
        this.webSocketHandler = null;
        this.errorHandler = null;
    }

    public ScxHttpServer requestHandler(Consumer<ScxHttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    public ScxHttpServer webSocketHandler(Consumer<ScxServerWebSocket> handler) {
        this.webSocketHandler = handler;
        return this;
    }

    public ScxHttpServer errorHandler(Consumer<Throwable> handler) {
        this.errorHandler = handler;
        return this;
    }

    public void start() {
        this.webServer.start();
    }

    public void stop() {
        this.webServer.stop();
    }

    public int port() {
        return this.webServer.port();
    }
}

