/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.helidon.HelidonHttpServer;
import cool.scx.http.helidon.HelidonHttpServerRequest;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import java.util.function.Supplier;

class HelidonHttpRouting
implements HttpRouting,
HttpRouting.Builder {
    private final HelidonHttpServer server;

    public HelidonHttpRouting(HelidonHttpServer server) {
        this.server = server;
    }

    public void route(ConnectionContext ctx, RoutingRequest request, RoutingResponse response) {
        if (this.server.requestHandler != null) {
            this.server.requestHandler.accept(new HelidonHttpServerRequest(ctx, request, response));
        }
    }

    public HttpSecurity security() {
        return null;
    }

    public HttpRouting.Builder register(HttpService ... service) {
        return this;
    }

    public HttpRouting.Builder register(String path, HttpService ... service) {
        return this;
    }

    public HttpRouting.Builder route(HttpRoute route) {
        return this;
    }

    public HttpRouting.Builder addFilter(Filter filter) {
        return this;
    }

    public HttpRouting.Builder addFeature(Supplier<? extends HttpFeature> feature) {
        return this;
    }

    public <T extends Throwable> HttpRouting.Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
        return this;
    }

    public HttpRouting.Builder maxReRouteCount(int maxReRouteCount) {
        return this;
    }

    public HttpRouting.Builder security(HttpSecurity security) {
        return this;
    }

    public HttpRouting.Builder copy() {
        return this;
    }

    public HttpRouting build() {
        return this;
    }
}

