/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.HttpVersion;
import cool.scx.http.PeerInfo;
import cool.scx.http.ScxHttpBody;
import cool.scx.http.ScxHttpBodyImpl;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpMethod;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.helidon.HelidonHelper;
import cool.scx.http.helidon.HelidonHttpServerResponse;
import cool.scx.http.helidon.HelidonPeerInfo;
import cool.scx.http.helidon.HelidonRoutePath;
import cool.scx.http.uri.ScxURI;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.RoutedPath;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import java.net.URI;

class HelidonHttpServerRequest
implements ScxHttpServerRequest {
    private final ScxHttpMethod method;
    private final ScxURI uri;
    private final HttpVersion version;
    private final ScxHttpHeaders headers;
    private final ScxHttpBody body;
    private final ScxHttpServerResponse response;
    private final HelidonPeerInfo remotePeer;
    private final HelidonPeerInfo localPeer;

    public HelidonHttpServerRequest(ConnectionContext ctx, RoutingRequest request, RoutingResponse response) {
        HttpPrologue p = request.prologue();
        request.path((RoutedPath)new HelidonRoutePath(p));
        this.method = ScxHttpMethod.of((String)p.method().text());
        this.uri = ScxURI.of((URI)request.requestedUri().toUri());
        this.version = HttpVersion.of((String)p.rawProtocol());
        this.headers = HelidonHelper.convertHeaders((Headers)request.headers());
        this.body = new ScxHttpBodyImpl(request.content().inputStream(), this.headers);
        this.response = new HelidonHttpServerResponse(this, response);
        this.remotePeer = new HelidonPeerInfo(request.remotePeer());
        this.localPeer = new HelidonPeerInfo(request.localPeer());
    }

    public ScxHttpMethod method() {
        return this.method;
    }

    public ScxURI uri() {
        return this.uri;
    }

    public HttpVersion version() {
        return this.version;
    }

    public ScxHttpHeaders headers() {
        return this.headers;
    }

    public ScxHttpBody body() {
        return this.body;
    }

    public ScxHttpServerResponse response() {
        return this.response;
    }

    public PeerInfo remotePeer() {
        return this.remotePeer;
    }

    public PeerInfo localPeer() {
        return this.localPeer;
    }
}

