/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ScxClientWebSocketBuilder;
import cool.scx.http.ScxHttpClient;
import cool.scx.http.ScxHttpClientOptions;
import cool.scx.http.helidon.HelidonClientWebSocket;
import cool.scx.http.helidon.HelidonHttpClientRequest;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;

public class HelidonHttpClient
implements ScxHttpClient {
    private final WebClient webClient;
    private final ScxHttpClientOptions options;

    public HelidonHttpClient(ScxHttpClientOptions options) {
        this.options = options;
        WebClientConfig.Builder builder = WebClient.builder();
        if (options.proxy() != null) {
            ScxHttpClientOptions.Proxy p = options.proxy();
            Proxy.Builder proxy = Proxy.builder().host(p.host()).port(p.port()).username(p.username());
            if (p.password() != null) {
                proxy.password(p.password());
            }
            builder.proxy(proxy.build());
        }
        this.webClient = builder.build();
    }

    public HelidonHttpClient() {
        this(new ScxHttpClientOptions());
    }

    public HelidonHttpClientRequest request() {
        return new HelidonHttpClientRequest(this.webClient, this);
    }

    public ScxClientWebSocketBuilder webSocket() {
        return new HelidonClientWebSocket();
    }

    public ScxHttpClientOptions options() {
        return this.options;
    }
}

