/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ScxWebSocket;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.websocket.WsListener;
import io.helidon.websocket.WsSession;
import io.helidon.websocket.WsUpgradeException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class HelidonWebSocket
implements ScxWebSocket,
WsListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    protected HttpPrologue prologue;
    protected Headers headers;
    protected WsSession wsSession;
    private Consumer<String> textMessageHandler;
    private Consumer<byte[]> binaryMessageHandler;
    private Consumer<byte[]> pingHandler;
    private Consumer<byte[]> pongHandler;
    private BiConsumer<Integer, String> closeHandler;
    private Consumer<Throwable> errorHandler;
    private final Lock lock = new ReentrantLock();

    public HelidonWebSocket onTextMessage(Consumer<String> textMessageHandler) {
        this.textMessageHandler = textMessageHandler;
        return this;
    }

    public HelidonWebSocket onBinaryMessage(Consumer<byte[]> binaryMessageHandler) {
        this.binaryMessageHandler = binaryMessageHandler;
        return this;
    }

    public HelidonWebSocket onPing(Consumer<byte[]> pingHandler) {
        this.pingHandler = pingHandler;
        return this;
    }

    public HelidonWebSocket onPong(Consumer<byte[]> pongHandler) {
        this.pongHandler = pongHandler;
        return this;
    }

    public HelidonWebSocket onClose(BiConsumer<Integer, String> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public HelidonWebSocket onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ScxWebSocket send(String textMessage, boolean var2) {
        if (this.wsSession == null) {
            throw new IllegalStateException("wsSession is null");
        }
        this.lock.lock();
        try {
            this.wsSession.send(textMessage, var2);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public ScxWebSocket send(byte[] binaryMessage, boolean var2) {
        if (this.wsSession == null) {
            throw new IllegalStateException("wsSession is null");
        }
        this.lock.lock();
        try {
            this.wsSession.send(BufferData.create((byte[])binaryMessage), var2);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public ScxWebSocket ping(byte[] data) {
        if (this.wsSession == null) {
            throw new IllegalStateException("wsSession is null");
        }
        this.lock.lock();
        try {
            this.wsSession.ping(BufferData.create((byte[])data));
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public ScxWebSocket pong(byte[] data) {
        if (this.wsSession == null) {
            throw new IllegalStateException("wsSession is null");
        }
        this.lock.lock();
        try {
            this.wsSession.pong(BufferData.create((byte[])data));
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public ScxWebSocket close(int var1, String var2) {
        if (this.wsSession == null) {
            throw new IllegalStateException("wsSession is null");
        }
        this.lock.lock();
        try {
            this.wsSession.close(var1, var2);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public ScxWebSocket terminate() {
        if (this.wsSession == null) {
            throw new IllegalStateException("wsSession is null");
        }
        this.lock.lock();
        try {
            this.wsSession.terminate();
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void onMessage(WsSession session, String text, boolean last) {
        if (this.textMessageHandler != null) {
            this.textMessageHandler.accept(text);
        }
    }

    public void onMessage(WsSession session, BufferData buffer, boolean last) {
        if (this.binaryMessageHandler != null) {
            this.binaryMessageHandler.accept(buffer.readBytes());
        }
    }

    public void onPing(WsSession session, BufferData buffer) {
        if (this.pingHandler != null) {
            this.pingHandler.accept(buffer.readBytes());
        }
    }

    public void onPong(WsSession session, BufferData buffer) {
        if (this.pongHandler != null) {
            this.pongHandler.accept(buffer.readBytes());
        }
    }

    public void onClose(WsSession session, int status, String reason) {
        this.closed.set(true);
        if (this.closeHandler != null) {
            this.closeHandler.accept(status, reason);
        }
    }

    public void onError(WsSession session, Throwable t) {
        this.closed.set(true);
        if (this.errorHandler != null) {
            this.errorHandler.accept(t);
        }
    }

    public void onOpen(WsSession session) {
        this.wsSession = session;
    }

    public Optional<Headers> onHttpUpgrade(HttpPrologue prologue, Headers headers) throws WsUpgradeException {
        this.prologue = prologue;
        this.headers = headers;
        return super.onHttpUpgrade(prologue, headers);
    }
}

