/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ScxClientWebSocket;
import cool.scx.http.ScxClientWebSocketBuilder;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.helidon.HelidonWebSocket;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import io.helidon.webclient.websocket.WsClient;
import io.helidon.webclient.websocket.WsClientConfig;
import io.helidon.websocket.WsListener;
import io.helidon.websocket.WsSession;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class HelidonClientWebSocket
extends HelidonWebSocket
implements ScxClientWebSocket,
ScxClientWebSocketBuilder {
    private Consumer<ScxClientWebSocket> connectHandler;
    private ScxURIWritable uri;
    private ScxHttpHeadersWritable builderHeaders = ScxHttpHeaders.of();

    public ScxURIWritable uri() {
        return this.uri;
    }

    public HelidonClientWebSocket uri(ScxURI uri) {
        this.uri = ScxURI.of((ScxURI)uri);
        return this;
    }

    public ScxHttpHeadersWritable headers() {
        return this.builderHeaders;
    }

    public ScxClientWebSocketBuilder headers(ScxHttpHeaders headers) {
        this.builderHeaders = ScxHttpHeaders.of((ScxHttpHeaders)headers);
        return this;
    }

    @Override
    public void onOpen(WsSession session) {
        super.onOpen(session);
        if (this.connectHandler != null) {
            this.connectHandler.accept(this);
        }
    }

    public HelidonClientWebSocket onConnect(Consumer<ScxClientWebSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    public void connect() {
        WsClientConfig.Builder wsClientBuilder = WsClient.builder();
        for (Map.Entry i : this.builderHeaders) {
            ScxHttpHeaderName key = (ScxHttpHeaderName)i.getKey();
            List values = (List)i.getValue();
            for (String value : values) {
                wsClientBuilder.addHeader(key.value(), value);
            }
        }
        WsClient wsClient = wsClientBuilder.build();
        wsClient.connect(this.uri.toURI(), (WsListener)this);
    }
}

