/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.helidon.HelidonClientWebSocket;
import cool.scx.http.helidon.HelidonHttpClient;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.web_socket.ScxClientWebSocket;
import cool.scx.http.web_socket.ScxClientWebSocketBuilder;
import io.helidon.webclient.websocket.WsClient;
import io.helidon.webclient.websocket.WsClientConfig;
import io.helidon.websocket.WsListener;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class HelidonClientWebSocketBuilder
implements ScxClientWebSocketBuilder {
    Consumer<ScxClientWebSocket> connectHandler;
    private ScxURIWritable uri;
    private ScxHttpHeadersWritable headers = ScxHttpHeaders.of();

    public HelidonClientWebSocketBuilder(HelidonHttpClient httpClient) {
    }

    public ScxURIWritable uri() {
        return this.uri;
    }

    public ScxClientWebSocketBuilder uri(ScxURI uri) {
        this.uri = ScxURI.of((ScxURI)uri);
        return this;
    }

    public ScxHttpHeadersWritable headers() {
        return this.headers;
    }

    public ScxClientWebSocketBuilder headers(ScxHttpHeaders headers) {
        this.headers = ScxHttpHeaders.of((ScxHttpHeaders)headers);
        return this;
    }

    public ScxClientWebSocketBuilder onConnect(Consumer<ScxClientWebSocket> onConnect) {
        this.connectHandler = onConnect;
        return this;
    }

    public void connect() {
        WsClientConfig.Builder wsClientBuilder = WsClient.builder();
        for (Map.Entry i : this.headers) {
            ScxHttpHeaderName key = (ScxHttpHeaderName)i.getKey();
            List values = (List)i.getValue();
            for (String value : values) {
                wsClientBuilder.addHeader(key.value(), value);
            }
        }
        WsClient wsClient = wsClientBuilder.build();
        wsClient.connect(this.uri.toURI(), (WsListener)new HelidonClientWebSocket(this));
    }
}

