/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.ParametersWritable;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeadersWritable;
import io.helidon.http.Header;
import io.helidon.http.HeaderNames;
import io.helidon.http.ServerResponseHeaders;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class HelidonHeadersWritable
implements ScxHttpHeadersWritable {
    private final ServerResponseHeaders headers;

    public HelidonHeadersWritable(ServerResponseHeaders headers) {
        this.headers = headers;
    }

    public ParametersWritable<ScxHttpHeaderName, String> set(ScxHttpHeaderName name, String ... value) {
        this.headers.set(HeaderNames.create((String)name.value()), value);
        return this;
    }

    public ParametersWritable<ScxHttpHeaderName, String> add(ScxHttpHeaderName name, String ... value) {
        this.headers.add(HeaderNames.create((String)name.value()), value);
        return this;
    }

    public ParametersWritable<ScxHttpHeaderName, String> remove(ScxHttpHeaderName name) {
        this.headers.remove(HeaderNames.create((String)name.value()));
        return this;
    }

    public ParametersWritable<ScxHttpHeaderName, String> clear() {
        this.headers.clear();
        return this;
    }

    public long size() {
        return this.headers.size();
    }

    public Set<ScxHttpHeaderName> names() {
        return this.headers.stream().map(c -> ScxHttpHeaderName.of((String)c.name())).collect(Collectors.toSet());
    }

    public String get(ScxHttpHeaderName name) {
        return this.headers.value(HeaderNames.create((String)name.value())).orElse(null);
    }

    public List<String> getAll(ScxHttpHeaderName name) {
        return this.headers.values(HeaderNames.create((String)name.value()));
    }

    public Iterator<Map.Entry<ScxHttpHeaderName, List<String>>> iterator() {
        final Iterator iterator = this.headers.iterator();
        return new Iterator<Map.Entry<ScxHttpHeaderName, List<String>>>(this){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<ScxHttpHeaderName, List<String>> next() {
                Header next = (Header)iterator.next();
                return new AbstractMap.SimpleEntry<ScxHttpHeaderName, List<String>>(ScxHttpHeaderName.of((String)next.name()), next.allValues());
            }
        };
    }
}

