/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.PeerInfo;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.helidon.HelidonHttpServer;
import cool.scx.http.helidon.HelidonServerWebSocket;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ReflectFactory;
import io.helidon.http.Header;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.webserver.websocket.WsRouting;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;

class HelidonHelper {
    HelidonHelper() {
    }

    public static WsRouting.Builder createHelidonWebSocketRouting(HelidonHttpServer server) {
        try {
            ClassInfo wsRouteClassInfo = ReflectFactory.getClassInfo(WsRoute.class);
            ConstructorInfo constructor = wsRouteClassInfo.constructors()[0];
            constructor.setAccessible(true);
            Object wsRoute = constructor.newInstance(new Object[]{PathMatchers.any(), () -> new HelidonServerWebSocket(server)});
            WsRouting.Builder builder = WsRouting.builder();
            ClassInfo classInfo = ReflectFactory.getClassInfo(WsRouting.Builder.class);
            MethodInfo routeMethod = Arrays.stream(classInfo.methods()).filter(method -> method.name().equals("route")).findFirst().orElseThrow();
            routeMethod.setAccessible(true);
            routeMethod.method().invoke((Object)builder, wsRoute);
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ScxHttpHeadersWritable convertHeaders(Headers o) {
        ScxHttpHeadersWritable h = ScxHttpHeaders.of();
        for (Header header : o) {
            h.add(header.name(), header.allValues().toArray(new String[0]));
        }
        return h;
    }

    public static ScxURIWritable createScxURI(HttpPrologue p) {
        String path = p.uriPath().path();
        String query = p.query().value();
        String fragment = p.fragment().hasValue() ? p.fragment().value() : null;
        return ScxURI.of().path(path).query(query).fragment(fragment);
    }

    public static PeerInfo convertPeerInfo(io.helidon.common.socket.PeerInfo peerInfo) {
        return PeerInfo.of().address(peerInfo.address()).host(peerInfo.host()).port(peerInfo.port()).tlsPrincipal((Principal)peerInfo.tlsPrincipal().orElse(null)).tlsCertificates((Certificate[])peerInfo.tlsCertificates().orElse(null));
    }
}

