/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import io.helidon.common.tls.Tls;

public class HelidonHttpServerOptions {
    private int port;
    private Tls tls;
    private long maxPayloadSize;
    private int bodyBufferSize;
    private int maxWebSocketFrameLength;

    public HelidonHttpServerOptions() {
        this.port = 0;
        this.tls = null;
        this.maxPayloadSize = -1L;
        this.bodyBufferSize = 65536;
        this.maxWebSocketFrameLength = 0x100000;
    }

    public HelidonHttpServerOptions(HelidonHttpServerOptions oldOptions) {
        this.port = oldOptions.port;
        this.tls = oldOptions.tls;
        this.maxPayloadSize = oldOptions.maxPayloadSize;
        this.bodyBufferSize = oldOptions.bodyBufferSize;
        this.maxWebSocketFrameLength = oldOptions.maxWebSocketFrameLength;
    }

    public int port() {
        return this.port;
    }

    public HelidonHttpServerOptions port(int port) {
        if (port > 65535) {
            throw new IllegalArgumentException("port must be <= 65535");
        }
        this.port = port;
        return this;
    }

    public Tls tls() {
        return this.tls;
    }

    public HelidonHttpServerOptions tls(Tls tls) {
        this.tls = tls;
        return this;
    }

    public long maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public HelidonHttpServerOptions maxPayloadSize(long maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
        return this;
    }

    public int maxWebSocketFrameLength() {
        return this.maxWebSocketFrameLength;
    }

    public HelidonHttpServerOptions maxWebSocketFrameLength(int maxWebSocketFrameLength) {
        this.maxWebSocketFrameLength = maxWebSocketFrameLength;
        return this;
    }

    public int bodyBufferSize() {
        return this.bodyBufferSize;
    }

    public HelidonHttpServerOptions bodyBufferSize(int bodyBufferSize) {
        this.bodyBufferSize = bodyBufferSize;
        return this;
    }
}

