/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.HttpStatusCode;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.helidon.HelidonHeadersWritable;
import cool.scx.http.helidon.HelidonHttpServerRequest;
import io.helidon.webserver.http.RoutingResponse;
import java.io.OutputStream;

class HelidonHttpServerResponse
implements ScxHttpServerResponse {
    private final RoutingResponse response;
    private final ScxHttpHeadersWritable headers;
    private final HelidonHttpServerRequest request;

    public HelidonHttpServerResponse(HelidonHttpServerRequest request, RoutingResponse response) {
        this.request = request;
        this.response = response;
        this.headers = new HelidonHeadersWritable(response.headers());
    }

    public ScxHttpServerRequest request() {
        return this.request;
    }

    public HttpStatusCode status() {
        return HttpStatusCode.of((int)this.response.status().code());
    }

    public ScxHttpHeadersWritable headers() {
        return this.headers;
    }

    public ScxHttpServerResponse status(HttpStatusCode code) {
        this.response.status(code.code());
        return this;
    }

    public OutputStream outputStream() {
        return this.response.outputStream();
    }

    public void end() {
        this.response.commit();
    }

    public boolean isClosed() {
        return this.response.isSent();
    }
}

