/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.helidon;

import cool.scx.http.HttpStatusCode;
import cool.scx.http.ScxHttpBody;
import cool.scx.http.ScxHttpBodyImpl;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.helidon.HelidonHelper;
import cool.scx.http.helidon.HelidonHttpClient;
import io.helidon.http.Headers;
import io.helidon.webclient.api.HttpClientResponse;

class HelidonHttpClientResponse
implements ScxHttpClientResponse {
    private final HttpClientResponse response;
    private final HttpStatusCode status;
    private final ScxHttpHeaders headers;
    private final ScxHttpBody body;

    public HelidonHttpClientResponse(HttpClientResponse response, HelidonHttpClient client) {
        this.response = response;
        this.status = HttpStatusCode.of((int)response.status().code());
        this.headers = HelidonHelper.convertHeaders((Headers)response.headers());
        this.body = new ScxHttpBodyImpl(response.entity().inputStream(), this.headers, client.options().bodyBufferSize());
    }

    public HttpStatusCode status() {
        return this.status;
    }

    public ScxHttpHeaders headers() {
        return this.headers;
    }

    public ScxHttpBody body() {
        return this.body;
    }
}

