/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.peach;

import cool.scx.http.WebSocketOpCode;
import cool.scx.http.peach.WebSocketFrame;
import cool.scx.io.DataReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class WebSocketFrameHelper {
    public static WebSocketFrame readFrame(DataReader reader) {
        byte[] header = reader.read(2);
        byte b1 = header[0];
        byte b2 = header[1];
        boolean fin = (b1 & 0x80) != 0;
        WebSocketOpCode opCode = WebSocketOpCode.of((int)(b1 & 0xF));
        boolean masked = (b2 & 0x80) != 0;
        int payloadLength = b2 & 0x7F;
        byte[] extendedPayloadLength = new byte[]{};
        if (payloadLength == 126) {
            extendedPayloadLength = reader.read(2);
            payloadLength = 0;
        } else if (payloadLength == 127) {
            extendedPayloadLength = reader.read(8);
            payloadLength = 0;
        }
        for (byte b : extendedPayloadLength) {
            payloadLength = payloadLength << 8 | b & 0xFF;
        }
        byte[] maskingKey = null;
        if (masked) {
            maskingKey = reader.read(4);
        }
        byte[] payloadData = reader.read(payloadLength);
        if (masked) {
            for (int i = 0; i < payloadLength; ++i) {
                payloadData[i] = (byte)(payloadData[i] ^ maskingKey[i % 4]);
            }
        }
        return new WebSocketFrame(fin, opCode, masked, payloadLength, maskingKey, payloadData);
    }

    public static WebSocketFrame readFrameUntilLast(DataReader reader) {
        WebSocketFrame webSocketFrame;
        ArrayList<WebSocketFrame> frameList = new ArrayList<WebSocketFrame>();
        do {
            webSocketFrame = WebSocketFrameHelper.readFrame(reader);
            frameList.add(webSocketFrame);
        } while (!webSocketFrame.fin());
        WebSocketFrame first = (WebSocketFrame)frameList.get(0);
        if (frameList.size() == 1) {
            return first;
        }
        WebSocketOpCode opCode = first.opCode();
        int length = frameList.stream().mapToInt(WebSocketFrame::payloadLength).sum();
        byte[] payloadData = new byte[length];
        int offset = 0;
        for (WebSocketFrame webSocketFrame2 : frameList) {
            System.arraycopy(webSocketFrame2.payloadData(), 0, payloadData, offset, webSocketFrame2.payloadLength());
            offset += webSocketFrame2.payloadLength();
        }
        return new WebSocketFrame(true, opCode, payloadData);
    }

    public static void writeFrame(WebSocketFrame frame, OutputStream out, int maxFrameSize) throws IOException, IOException {
    }

    public static void writeFrame(WebSocketFrame frame, OutputStream out) throws IOException, IOException {
        int b1 = (frame.fin() ? 128 : 0) | frame.opCode().code();
        int b2 = frame.payloadLength();
        if (frame.masked()) {
            b2 |= 0x80;
        }
        out.write(b1);
        out.write(b2);
        if (frame.payloadLength() >= 126) {
            if (frame.payloadLength() <= 65535) {
                out.write(frame.payloadLength() >> 8 & 0xFF);
                out.write(frame.payloadLength() & 0xFF);
            } else {
                for (int i = 7; i >= 0; --i) {
                    out.write(frame.payloadLength() >> 8 * i & 0xFF);
                }
            }
        }
        if (frame.masked() && frame.maskingKey() != null) {
            out.write(frame.maskingKey());
        }
        byte[] payloadData = frame.payloadData();
        if (frame.masked() && frame.maskingKey() != null) {
            for (int i = 0; i < payloadData.length; ++i) {
                payloadData[i] = (byte)(payloadData[i] ^ frame.maskingKey()[i % 4]);
            }
        }
        out.write(payloadData);
        out.flush();
    }
}

