/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.peach;

import cool.scx.http.HttpFieldName;
import cool.scx.http.HttpVersion;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.ScxHttpMethod;
import cool.scx.http.ScxHttpServer;
import cool.scx.http.ScxHttpServerOptions;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.peach.PeachHttpServerRequest;
import cool.scx.http.peach.PeachHttpServerResponse;
import cool.scx.http.peach.PeachScxHttpBody;
import cool.scx.http.uri.ScxURI;
import cool.scx.io.LinkedDataReader;
import cool.scx.net.ScxTCPServer;
import cool.scx.net.ScxTCPServerOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.TCPServer;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;

public class PeachHttpServer
implements ScxHttpServer {
    private final Function<ScxTCPServerOptions, ScxTCPServer> tcpServerBuilder;
    private final ScxTCPServer tcpServer;
    private final ScxHttpServerOptions options;
    private Consumer<ScxHttpServerRequest> requestHandler;
    private Consumer<ScxServerWebSocket> webSocketHandler;
    private Consumer<Throwable> errorHandler;

    public PeachHttpServer(ScxHttpServerOptions options, Function<ScxTCPServerOptions, ScxTCPServer> tcpServerBuilder) {
        this.options = options;
        this.tcpServerBuilder = tcpServerBuilder;
        this.tcpServer = tcpServerBuilder.apply(new ScxTCPServerOptions().port(options.port()));
        this.tcpServer.onConnect(this::listen);
    }

    public PeachHttpServer(ScxHttpServerOptions options) {
        this(options, TCPServer::new);
    }

    public PeachHttpServer() {
        this(new ScxHttpServerOptions());
    }

    private void listen(ScxTCPSocket scxTCPSocket) {
        LinkedDataReader dataReader = new LinkedDataReader(() -> {
            try {
                byte[] read = scxTCPSocket.read(8192);
                return new LinkedDataReader.Node(read);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        while (true) {
            byte[] requestLineBytes;
            String requestLine;
            String[] split;
            if ((split = (requestLine = new String(requestLineBytes = dataReader.readUntil("\r\n".getBytes()))).split(" ")).length != 3) {
                throw new RuntimeException("Invalid request line: " + requestLine);
            }
            String method = split[0];
            String path = split[1];
            String version = split[2];
            PeachHttpServerRequest request = new PeachHttpServerRequest();
            request.method = ScxHttpMethod.of((String)method);
            request.uri = ScxURI.of((String)URLDecoder.decode(path, StandardCharsets.UTF_8));
            request.version = HttpVersion.of((String)version);
            byte[] headerBytes = dataReader.readUntil("\r\n\r\n".getBytes());
            String headerStr = new String(headerBytes);
            ScxHttpHeadersWritable headers = ScxHttpHeaders.of((String)headerStr);
            request.headers = headers;
            PeachScxHttpBody body = null;
            Long contentLength = headers.contentLength();
            body = contentLength != null ? new PeachScxHttpBody(dataReader, (ScxHttpHeaders)headers, contentLength) : new PeachScxHttpBody(dataReader, (ScxHttpHeaders)headers, 0L);
            request.body = body;
            PeachHttpServerResponse response = new PeachHttpServerResponse(request, scxTCPSocket);
            response.headers().set((Object)HttpFieldName.CONNECTION, (Object[])new String[]{"keep-alive"});
            response.headers().set((Object)HttpFieldName.SERVER, (Object[])new String[]{"Scx Peach"});
            request.response = response;
            if (this.requestHandler == null) continue;
            this.requestHandler.accept(request);
        }
    }

    public ScxHttpServer requestHandler(Consumer<ScxHttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    public ScxHttpServer webSocketHandler(Consumer<ScxServerWebSocket> handler) {
        this.webSocketHandler = handler;
        return this;
    }

    public ScxHttpServer errorHandler(Consumer<Throwable> handler) {
        this.errorHandler = handler;
        return this;
    }

    public void start() {
        this.tcpServer.start();
    }

    public void stop() {
        this.tcpServer.stop();
    }

    public int port() {
        return this.tcpServer.port();
    }
}

