/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.peach;

import cool.scx.http.HttpStatusCode;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.peach.PeachHttpServerRequest;
import cool.scx.net.ScxTCPSocket;
import java.io.IOException;
import java.io.OutputStream;

public class PeachHttpServerResponse
implements ScxHttpServerResponse {
    private final PeachHttpServerRequest request;
    private final ScxTCPSocket tcpSocket;
    private final OutputStream outputStream;
    private final ScxHttpHeadersWritable headers;
    private HttpStatusCode status;
    private boolean firstSend;

    PeachHttpServerResponse(PeachHttpServerRequest request, final ScxTCPSocket tcpSocket) {
        this.request = request;
        this.tcpSocket = tcpSocket;
        this.headers = ScxHttpHeaders.of();
        this.firstSend = true;
        this.status = HttpStatusCode.OK;
        this.outputStream = new OutputStream(this){
            final /* synthetic */ PeachHttpServerResponse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(int b) throws IOException {
                this.this$0.checkFirstSend();
                tcpSocket.write(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.this$0.checkFirstSend();
                tcpSocket.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.this$0.checkFirstSend();
                tcpSocket.write(b, off, len);
            }
        };
    }

    public ScxHttpServerRequest request() {
        return this.request;
    }

    public HttpStatusCode status() {
        return this.status;
    }

    public ScxHttpHeadersWritable headers() {
        return this.headers;
    }

    public ScxHttpServerResponse status(HttpStatusCode code) {
        this.status = code;
        return this;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public void end() {
    }

    public boolean isClosed() {
        return false;
    }

    public void checkFirstSend() {
        if (this.firstSend) {
            this.doFirstSend();
            this.firstSend = false;
        }
    }

    public void doFirstSend() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.request.version.value());
        sb.append(" ");
        sb.append(this.status.code());
        sb.append(" ");
        sb.append(this.status.description());
        sb.append("\r\n");
        String headerStr = this.headers.encode();
        sb.append(headerStr);
        sb.append("\r\n");
        try {
            this.tcpSocket.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

