/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.peach;

import cool.scx.http.HttpFieldName;
import cool.scx.http.HttpMethod;
import cool.scx.http.HttpVersion;
import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.ScxHttpMethod;
import cool.scx.http.ScxHttpServer;
import cool.scx.http.ScxHttpServerOptions;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.peach.PeachHttpServerRequest;
import cool.scx.http.peach.PeachHttpServerResponse;
import cool.scx.http.peach.PeachScxHttpBody;
import cool.scx.http.peach.PeachServerWebSocket;
import cool.scx.http.peach.PeachServerWebSocketHandshakeRequest;
import cool.scx.http.uri.ScxURI;
import cool.scx.io.DataReader;
import cool.scx.io.InputStreamDataSupplier;
import cool.scx.io.LinkedDataReader;
import cool.scx.net.ClassicTCPServer;
import cool.scx.net.ScxTCPServer;
import cool.scx.net.ScxTCPServerOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.tls.TLS;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class PeachHttpServer
implements ScxHttpServer {
    private final ScxTCPServer tcpServer;
    private final ScxHttpServerOptions options;
    private Consumer<ScxHttpServerRequest> requestHandler;
    private Consumer<ScxServerWebSocket> webSocketHandler;
    private Consumer<Throwable> errorHandler;

    public PeachHttpServer(ScxHttpServerOptions options) {
        this.options = options;
        this.tcpServer = new ClassicTCPServer(new ScxTCPServerOptions().port(options.port()).tls((TLS)options.tls()));
        this.tcpServer.onConnect(this::handle);
    }

    public PeachHttpServer() {
        this(new ScxHttpServerOptions());
    }

    private void handle(ScxTCPSocket scxTCPSocket) {
        block2: {
            PeachHttpServerRequest request;
            LinkedDataReader dataReader = new LinkedDataReader((Supplier)new InputStreamDataSupplier(scxTCPSocket.inputStream()));
            do {
                byte[] requestLineBytes;
                String requestLine;
                String[] split;
                if ((split = (requestLine = new String(requestLineBytes = dataReader.readUntil("\r\n".getBytes()))).split(" ")).length != 3) {
                    throw new RuntimeException("Invalid request line: " + requestLine);
                }
                String method0 = split[0];
                String path0 = split[1];
                String version0 = split[2];
                ScxHttpMethod method = ScxHttpMethod.of((String)method0);
                String path = URLDecoder.decode(path0, StandardCharsets.UTF_8);
                HttpVersion version = HttpVersion.of((String)version0);
                byte[] headerBytes = dataReader.readUntil("\r\n\r\n".getBytes());
                String headerStr = new String(headerBytes);
                ScxHttpHeadersWritable headers = ScxHttpHeaders.of((String)headerStr);
                String connection = (String)headers.get((Object)HttpFieldName.CONNECTION);
                String upgrade = (String)headers.get((Object)HttpFieldName.UPGRADE);
                boolean isWebSocketHandshake = method == HttpMethod.GET && "Upgrade".equals(connection) && "websocket".equals(upgrade);
                request = isWebSocketHandshake ? new PeachServerWebSocketHandshakeRequest((DataReader)dataReader, scxTCPSocket.outputStream()) : new PeachHttpServerRequest();
                request.method = method;
                request.uri = ScxURI.of((String)path);
                request.version = version;
                request.headers = headers;
                PeachScxHttpBody body = null;
                Long contentLength = headers.contentLength();
                body = contentLength != null ? new PeachScxHttpBody(dataReader, (ScxHttpHeaders)headers, contentLength) : new PeachScxHttpBody(dataReader, (ScxHttpHeaders)headers, 0L);
                request.body = body;
                PeachHttpServerResponse response = new PeachHttpServerResponse(request, scxTCPSocket);
                response.headers().set((Object)HttpFieldName.CONNECTION, (Object[])new String[]{"keep-alive"});
                response.headers().set((Object)HttpFieldName.SERVER, (Object[])new String[]{"Scx Peach"});
                request.response = response;
                if (this.requestHandler == null) continue;
                this.requestHandler.accept(request);
            } while (!(request instanceof PeachServerWebSocketHandshakeRequest));
            PeachServerWebSocketHandshakeRequest w = (PeachServerWebSocketHandshakeRequest)request;
            PeachServerWebSocket ws = w.webSocket;
            if (ws == null) break block2;
            ws.start();
        }
    }

    public ScxHttpServer requestHandler(Consumer<ScxHttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    public ScxHttpServer webSocketHandler(Consumer<ScxServerWebSocket> handler) {
        this.webSocketHandler = handler;
        return this;
    }

    public ScxHttpServer errorHandler(Consumer<Throwable> handler) {
        this.errorHandler = handler;
        return this;
    }

    public void start() {
        this.tcpServer.start();
    }

    public void stop() {
        this.tcpServer.stop();
    }

    public int port() {
        return this.tcpServer.port();
    }
}

