/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.peach;

import cool.scx.http.ScxHttpHeaders;
import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.ScxServerWebSocketHandshakeRequest;
import cool.scx.http.ScxWebSocket;
import cool.scx.http.WebSocketOpCode;
import cool.scx.http.peach.WebSocketFrame;
import cool.scx.http.peach.WebSocketFrameHelper;
import cool.scx.http.uri.ScxURI;
import cool.scx.io.DataReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class PeachServerWebSocket
implements ScxServerWebSocket {
    private final DataReader reader;
    private final OutputStream writer;
    private final ScxServerWebSocketHandshakeRequest handshakeServerRequest;
    private Consumer<String> textMessageHandler;
    private Consumer<byte[]> binaryMessageHandler;
    private Consumer<byte[]> pingHandler;
    private Consumer<byte[]> pongHandler;
    private BiConsumer<Integer, String> closeHandler;
    private Consumer<Throwable> errorHandler;
    private boolean isClosed;

    public PeachServerWebSocket(ScxServerWebSocketHandshakeRequest handshakeServerRequest, DataReader reader, OutputStream writer) {
        this.handshakeServerRequest = handshakeServerRequest;
        this.reader = reader;
        this.writer = writer;
    }

    public ScxURI uri() {
        return this.handshakeServerRequest.uri();
    }

    public ScxHttpHeaders headers() {
        return this.handshakeServerRequest.headers();
    }

    public ScxWebSocket onTextMessage(Consumer<String> textMessageHandler) {
        this.textMessageHandler = textMessageHandler;
        return this;
    }

    public ScxWebSocket onBinaryMessage(Consumer<byte[]> binaryMessageHandler) {
        this.binaryMessageHandler = binaryMessageHandler;
        return this;
    }

    public ScxWebSocket onPing(Consumer<byte[]> pingHandler) {
        this.pingHandler = pingHandler;
        return this;
    }

    public ScxWebSocket onPong(Consumer<byte[]> pongHandler) {
        this.pongHandler = pongHandler;
        return this;
    }

    public ScxWebSocket onClose(BiConsumer<Integer, String> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public ScxWebSocket onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ScxWebSocket send(String textMessage, boolean last) {
        block2: {
            try {
                byte[] payload = textMessage.getBytes();
                this.sendFrame(payload, WebSocketOpCode.TEXT, last);
            }
            catch (Exception e) {
                if (this.errorHandler == null) break block2;
                this.errorHandler.accept(e);
            }
        }
        return this;
    }

    public ScxWebSocket send(byte[] binaryMessage, boolean last) {
        block2: {
            try {
                this.sendFrame(binaryMessage, WebSocketOpCode.BINARY, last);
            }
            catch (Exception e) {
                if (this.errorHandler == null) break block2;
                this.errorHandler.accept(e);
            }
        }
        return this;
    }

    public ScxWebSocket ping(byte[] data) {
        block2: {
            try {
                this.sendFrame(data, WebSocketOpCode.PING, true);
            }
            catch (Exception e) {
                if (this.errorHandler == null) break block2;
                this.errorHandler.accept(e);
            }
        }
        return this;
    }

    public ScxWebSocket pong(byte[] data) {
        block2: {
            try {
                this.sendFrame(data, WebSocketOpCode.PONG, true);
            }
            catch (Exception e) {
                if (this.errorHandler == null) break block2;
                this.errorHandler.accept(e);
            }
        }
        return this;
    }

    public ScxWebSocket close(int code, String reason) {
        block2: {
            try {
                this.sendFrame(reason.getBytes(), WebSocketOpCode.CLOSE, true);
            }
            catch (Exception e) {
                if (this.errorHandler == null) break block2;
                this.errorHandler.accept(e);
            }
        }
        return this;
    }

    public ScxWebSocket terminate() {
        this.isClosed = true;
        return this;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void start() {
        try {
            while (true) {
                WebSocketFrame frame = WebSocketFrameHelper.readFrameUntilLast(this.reader);
                this.handleFrame(frame);
            }
        }
        catch (Exception e) {
            block3: {
                if (this.errorHandler == null) break block3;
                this.errorHandler.accept(e);
            }
            return;
        }
    }

    private void handleFrame(WebSocketFrame frame) {
        switch (frame.opCode()) {
            case CONTINUATION: {
                break;
            }
            case TEXT: {
                this.textMessageHandler.accept(new String(frame.payloadData()));
                break;
            }
            case BINARY: {
                this.binaryMessageHandler.accept(frame.payloadData());
                break;
            }
            case CLOSE: {
                this.isClosed = true;
                this.closeHandler.accept(0, new String(frame.payloadData()));
                break;
            }
            case PING: {
                this.pingHandler.accept(frame.payloadData());
                break;
            }
            case PONG: {
                this.pongHandler.accept(frame.payloadData());
            }
        }
    }

    private void sendFrame(byte[] payload, WebSocketOpCode opcode, boolean last) throws IOException {
        WebSocketFrame f = new WebSocketFrame(last, opcode, payload);
        WebSocketFrameHelper.writeFrame(f, this.writer);
    }
}

