/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.http.x.http1.Http1Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AutoContinueInputStream
extends InputStream {
    private final InputStream in;
    private final OutputStream out;
    private boolean continueSent;

    public AutoContinueInputStream(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.continueSent = false;
    }

    @Override
    public int read() throws IOException {
        this.trySendContinueResponse();
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.trySendContinueResponse();
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.trySendContinueResponse();
        return this.in.read(b, off, len);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.trySendContinueResponse();
        return this.in.transferTo(out);
    }

    private void trySendContinueResponse() throws IOException {
        if (!this.continueSent) {
            Http1Helper.sendContinue100(this.out);
            this.continueSent = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

