/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.bytes.ByteReader;
import cool.scx.bytes.IByteReader;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.exception.NoMatchFoundException;
import cool.scx.bytes.exception.NoMoreDataException;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.exception.ContentTooLargeException;
import cool.scx.http.exception.URITooLongException;
import cool.scx.http.headers.ScxHttpHeadersHelper;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.x.http1.CloseConnectionException;
import cool.scx.http.x.http1.Http1Helper;
import cool.scx.http.x.http1.chunked.HttpChunkedByteSupplier;
import cool.scx.http.x.http1.exception.HttpVersionNotSupportedException;
import cool.scx.http.x.http1.exception.RequestHeaderFieldsTooLargeException;
import cool.scx.http.x.http1.fixed_length.FixedLengthByteSupplier;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.transfer_encoding.ScxTransferEncoding;
import cool.scx.http.x.http1.headers.transfer_encoding.TransferEncoding;
import cool.scx.http.x.http1.request_line.Http1RequestLine;
import cool.scx.http.x.http1.request_line.InvalidHttpRequestLineException;
import cool.scx.http.x.http1.request_line.InvalidHttpVersion;
import cool.scx.http.x.http1.status_line.Http1StatusLine;
import cool.scx.http.x.http1.status_line.InvalidHttpStatusException;
import cool.scx.http.x.http1.status_line.InvalidHttpStatusLineException;
import cool.scx.io.io_stream.ByteReaderInputStream;
import cool.scx.io.io_stream.NullCheckedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class Http1Reader {
    Http1Reader() {
    }

    public static InputStream readBodyInputStream(Http1Headers headers, ByteReader dataReader, long maxPayloadSize) {
        ScxTransferEncoding transferEncoding = headers.transferEncoding();
        if (transferEncoding == TransferEncoding.CHUNKED) {
            return new ByteReaderInputStream((ByteSupplier)new HttpChunkedByteSupplier(dataReader, maxPayloadSize));
        }
        Long contentLength = headers.contentLength();
        if (contentLength != null) {
            if (contentLength > maxPayloadSize) {
                throw new ContentTooLargeException();
            }
            return new ByteReaderInputStream((ByteSupplier)new FixedLengthByteSupplier((IByteReader)dataReader, contentLength));
        }
        return new NullCheckedInputStream();
    }

    public static Http1Headers readHeaders(ByteReader dataReader, int maxHeaderSize) {
        try {
            byte[] b = dataReader.peek(2);
            if (Arrays.equals(b, Http1Helper.CRLF_BYTES)) {
                dataReader.skip(2L);
                return new Http1Headers();
            }
            byte[] headerBytes = dataReader.readUntil(Http1Helper.CRLF_CRLF_BYTES, maxHeaderSize);
            String headerStr = new String(headerBytes, StandardCharsets.UTF_8);
            return (Http1Headers)ScxHttpHeadersHelper.parseHeaders((ScxHttpHeadersWritable)new Http1Headers(), (String)headerStr, (boolean)true);
        }
        catch (ByteSupplierException | NoMoreDataException e) {
            throw new CloseConnectionException("\u8bfb\u53d6 Headers \u5931\u8d25 !!!", e.getCause());
        }
        catch (NoMatchFoundException e) {
            throw new RequestHeaderFieldsTooLargeException(e.getMessage());
        }
    }

    public static Http1RequestLine readRequestLine(ByteReader dataReader, int maxRequestLineSize) {
        try {
            byte[] requestLineBytes = dataReader.readUntil(Http1Helper.CRLF_BYTES, maxRequestLineSize);
            String requestLineStr = new String(requestLineBytes, StandardCharsets.UTF_8);
            return Http1RequestLine.of(requestLineStr);
        }
        catch (ByteSupplierException | NoMoreDataException e) {
            throw new CloseConnectionException("\u8bfb\u53d6 RequestLine \u5931\u8d25 !!!", e.getCause());
        }
        catch (NoMatchFoundException e) {
            throw new URITooLongException(e.getMessage());
        }
        catch (InvalidHttpRequestLineException e) {
            throw new BadRequestException("Invalid HTTP request line : " + e.requestLineStr);
        }
        catch (InvalidHttpVersion e) {
            throw new HttpVersionNotSupportedException("Invalid HTTP version : " + e.versionStr);
        }
    }

    public static Http1StatusLine readStatusLine(ByteReader dataReader, int maxStatusLineSize) {
        try {
            byte[] statusLineBytes = dataReader.readUntil(Http1Helper.CRLF_BYTES, maxStatusLineSize);
            String statusLineStr = new String(statusLineBytes);
            return Http1StatusLine.of(statusLineStr);
        }
        catch (ByteSupplierException | NoMoreDataException e) {
            throw new CloseConnectionException("\u8bfb\u53d6 StatusLine \u65f6\u53d1\u751f\u5f02\u5e38 !!!", e.getCause());
        }
        catch (NoMatchFoundException e) {
            throw new RuntimeException("\u54cd\u5e94\u884c\u8fc7\u5927 !!!");
        }
        catch (InvalidHttpVersion | InvalidHttpStatusException | InvalidHttpStatusLineException e) {
            throw new RuntimeException(e);
        }
    }
}

