/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.sender.BodyAlreadySentException;
import cool.scx.http.sender.HttpSendException;
import cool.scx.http.status.HttpStatus;
import cool.scx.http.status.ScxHttpStatus;
import cool.scx.http.status.ScxHttpStatusHelper;
import cool.scx.http.x.http1.Http1Helper;
import cool.scx.http.x.http1.Http1ServerConnection;
import cool.scx.http.x.http1.Http1ServerRequest;
import cool.scx.http.x.http1.Http1ServerResponseOutputStream;
import cool.scx.http.x.http1.chunked.HttpChunkedOutputStream;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.headers.transfer_encoding.TransferEncoding;
import cool.scx.http.x.http1.status_line.Http1StatusLine;
import cool.scx.io.io_stream.CheckedOutputStream;
import cool.scx.io.io_stream.StreamClosedException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class Http1ServerResponse
implements ScxHttpServerResponse {
    public final Http1ServerConnection connection;
    private final Http1ServerRequest request;
    private Http1Headers headers;
    private ScxHttpStatus status;
    private String reasonPhrase;
    private OutputStream outputStream;

    Http1ServerResponse(Http1ServerConnection connection, Http1ServerRequest request) {
        this.connection = connection;
        this.request = request;
        this.status = HttpStatus.OK;
        this.headers = new Http1Headers();
    }

    public ScxHttpServerRequest request() {
        return this.request;
    }

    public ScxHttpStatus status() {
        return this.status;
    }

    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    public Http1ServerResponse reasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public Http1Headers headers() {
        return this.headers;
    }

    public ScxHttpServerResponse headers(ScxHttpHeaders headers) {
        this.headers = new Http1Headers(headers);
        return this;
    }

    public ScxHttpServerResponse status(ScxHttpStatus code) {
        this.status = code;
        return this;
    }

    public Void send(MediaWriter writer) throws BodyAlreadySentException {
        long expectedLength = writer.beforeWrite((ScxHttpHeadersWritable)this.headers, (ScxHttpHeaders)this.request.headers());
        try {
            writer.write(this.outputStream(expectedLength));
        }
        catch (IOException e) {
            throw new HttpSendException("\u53d1\u9001 HTTP \u54cd\u5e94\u5931\u8d25 !!!", (Throwable)e);
        }
        catch (StreamClosedException e) {
            throw new BodyAlreadySentException();
        }
        return null;
    }

    public boolean isSent() {
        OutputStream o;
        HttpChunkedOutputStream c;
        if (this.outputStream == null) {
            return false;
        }
        OutputStream outputStream = this.outputStream;
        if (outputStream instanceof HttpChunkedOutputStream) {
            c = (HttpChunkedOutputStream)outputStream;
            v0 = c.outputStream();
        } else {
            v0 = o = this.outputStream;
        }
        if (o instanceof CheckedOutputStream) {
            c = (CheckedOutputStream)o;
            return c.isClosed();
        }
        throw new IllegalStateException("unknown type output stream");
    }

    public String createReasonPhrase() {
        return this.reasonPhrase != null ? this.reasonPhrase : ScxHttpStatusHelper.getReasonPhrase((ScxHttpStatus)this.status, (String)"unknown");
    }

    private OutputStream outputStream(long expectedLength) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.sendHeaders(expectedLength);
        }
        return this.outputStream;
    }

    private OutputStream sendHeaders(long expectedLength) throws IOException {
        Http1StatusLine statusLine = new Http1StatusLine(this.request.version(), this.status.code(), this.createReasonPhrase());
        String statusLineStr = statusLine.encode();
        if (this.headers.connection() == null) {
            if (this.request.isKeepAlive()) {
                this.headers.connection(Connection.KEEP_ALIVE);
            } else {
                this.headers.connection(Connection.CLOSE);
            }
        }
        if (expectedLength < 0L) {
            if (this.headers.contentLength() == null) {
                this.headers.transferEncoding(TransferEncoding.CHUNKED);
            }
        } else if (expectedLength > 0L) {
            if (this.headers.transferEncoding() != TransferEncoding.CHUNKED) {
                this.headers.contentLength(expectedLength);
            }
        } else {
            boolean hasBody = Http1Helper.checkResponseHasBody(this.status);
            if (hasBody && this.headers.transferEncoding() != TransferEncoding.CHUNKED) {
                this.headers.contentLength(expectedLength);
            }
        }
        String responseHeaderStr = this.headers.encode();
        String h = statusLineStr + "\r\n" + responseHeaderStr + "\r\n";
        this.connection.dataWriter.write(h.getBytes(StandardCharsets.UTF_8));
        boolean closeConnection = this.headers.connection() == Connection.CLOSE;
        boolean useChunkedTransfer = this.headers.transferEncoding() == TransferEncoding.CHUNKED;
        Http1ServerResponseOutputStream baseOutputStream = new Http1ServerResponseOutputStream(this.connection, closeConnection);
        return useChunkedTransfer ? new HttpChunkedOutputStream((OutputStream)((Object)baseOutputStream)) : baseOutputStream;
    }
}

