/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.headers;

import cool.scx.function.Function2Void;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.parameters.ParameterEntry;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.headers.connection.ScxConnection;
import cool.scx.http.x.http1.headers.expect.ScxExpect;
import cool.scx.http.x.http1.headers.transfer_encoding.ScxTransferEncoding;
import cool.scx.http.x.http1.headers.upgrade.ScxUpgrade;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Http1Headers
implements ScxHttpHeadersWritable {
    private final ScxHttpHeadersWritable h;

    public Http1Headers(ScxHttpHeaders h) {
        this.h = ScxHttpHeaders.of((ScxHttpHeaders)h);
    }

    public Http1Headers() {
        this.h = ScxHttpHeaders.of();
    }

    public Http1Headers set(ScxHttpHeaderName name, String ... value) {
        this.h.set(name, value);
        return this;
    }

    public Http1Headers add(ScxHttpHeaderName name, String ... value) {
        this.h.add(name, value);
        return this;
    }

    public Http1Headers remove(ScxHttpHeaderName name) {
        this.h.remove(name);
        return this;
    }

    public Http1Headers clear() {
        this.h.clear();
        return this;
    }

    public long size() {
        return this.h.size();
    }

    public Set<ScxHttpHeaderName> names() {
        return this.h.names();
    }

    public String get(ScxHttpHeaderName name) {
        return (String)this.h.get((Object)name);
    }

    public List<String> getAll(ScxHttpHeaderName name) {
        return this.h.getAll((Object)name);
    }

    public boolean contains(ScxHttpHeaderName name) {
        return this.h.contains((Object)name);
    }

    public boolean isEmpty() {
        return this.h.isEmpty();
    }

    public Map<ScxHttpHeaderName, List<String>> toMultiValueMap() {
        return this.h.toMultiValueMap();
    }

    public Map<ScxHttpHeaderName, String> toMap() {
        return this.h.toMap();
    }

    public <X extends Throwable> void forEach(Function2Void<? super ScxHttpHeaderName, String, X> action) throws X {
        this.h.forEach(action);
    }

    public <X extends Throwable> void forEachParameter(Function2Void<? super ScxHttpHeaderName, List<String>, X> action) throws X {
        this.h.forEachParameter(action);
    }

    public Iterator<ParameterEntry<ScxHttpHeaderName, String>> iterator() {
        return this.h.iterator();
    }

    public String toString() {
        return this.h.toString();
    }

    public ScxConnection connection() {
        String c = this.get((ScxHttpHeaderName)HttpFieldName.CONNECTION);
        return c != null ? ScxConnection.of(c) : null;
    }

    public Http1Headers connection(Connection connection) {
        return this.set((ScxHttpHeaderName)HttpFieldName.CONNECTION, connection.value());
    }

    public ScxTransferEncoding transferEncoding() {
        String c = this.get((ScxHttpHeaderName)HttpFieldName.TRANSFER_ENCODING);
        return c != null ? ScxTransferEncoding.of(c) : null;
    }

    public Http1Headers transferEncoding(ScxTransferEncoding transferEncoding) {
        return this.set((ScxHttpHeaderName)HttpFieldName.TRANSFER_ENCODING, transferEncoding.value());
    }

    public ScxExpect expect() {
        String c = this.get((ScxHttpHeaderName)HttpFieldName.EXPECT);
        return c != null ? ScxExpect.of(c) : null;
    }

    public Http1Headers expect(ScxExpect expect) {
        return this.set((ScxHttpHeaderName)HttpFieldName.EXPECT, expect.value());
    }

    public ScxUpgrade upgrade() {
        String c = this.get((ScxHttpHeaderName)HttpFieldName.UPGRADE);
        return c != null ? ScxUpgrade.of(c) : null;
    }

    public Http1Headers upgrade(ScxUpgrade upgrade) {
        return this.set((ScxHttpHeaderName)HttpFieldName.UPGRADE, upgrade.value());
    }
}

