/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.request_line;

import cool.scx.http.method.HttpMethod;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.version.HttpVersion;
import cool.scx.http.x.HttpClientHelper;
import cool.scx.http.x.http1.request_line.Http1RequestLine;
import cool.scx.http.x.http1.request_line.InvalidHttpRequestLineException;
import cool.scx.http.x.http1.request_line.InvalidHttpVersion;
import cool.scx.http.x.http1.request_line.RequestTargetForm;
import java.net.URI;

public final class Http1RequestLineHelper {
    public static Http1RequestLine parseRequestLine(String requestLineStr) throws InvalidHttpVersion, InvalidHttpRequestLineException {
        ScxURI requestTarget;
        String[] parts = requestLineStr.split(" ");
        if (parts.length != 3) {
            throw new InvalidHttpRequestLineException(requestLineStr);
        }
        String methodStr = parts[0];
        String requestTargetStr = parts[1];
        String versionStr = parts[2];
        ScxHttpMethod method = ScxHttpMethod.of((String)methodStr);
        HttpVersion version = HttpVersion.find((String)versionStr);
        if (method == HttpMethod.CONNECT) {
            requestTarget = ScxURI.ofAuthority((String)requestTargetStr);
        } else {
            URI decodedPath;
            if ("".equals(requestTargetStr)) {
                requestTargetStr = "/";
            }
            try {
                decodedPath = URI.create(requestTargetStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidHttpRequestLineException(requestLineStr);
            }
            requestTarget = ScxURI.of((URI)decodedPath);
        }
        if (version != HttpVersion.HTTP_1_1) {
            throw new InvalidHttpVersion(versionStr);
        }
        return new Http1RequestLine(method, requestTarget, version);
    }

    public static String encodeRequestLine(Http1RequestLine requestLine, RequestTargetForm requestTargetForm) {
        String methodStr = requestLine.method().value();
        ScxURIWritable requestTarget = ScxURI.of((ScxURI)requestLine.requestTarget());
        if ("".equals(requestTarget.path())) {
            requestTarget.path("/");
        }
        String requestTargetStr = Http1RequestLineHelper.getRequestTargetStr(requestTarget, requestTargetForm);
        String versionStr = HttpVersion.HTTP_1_1.protocolVersion();
        return methodStr + " " + requestTargetStr + " " + versionStr;
    }

    public static String getRequestTargetStr(ScxURIWritable requestTarget, RequestTargetForm requestTargetForm) {
        return switch (requestTargetForm) {
            default -> throw new MatchException(null, null);
            case RequestTargetForm.ORIGIN_FORM -> requestTarget.scheme(null).host(null).encode(true);
            case RequestTargetForm.ABSOLUTE_FORM -> {
                String scheme = requestTarget.scheme().toLowerCase();
                if ("ws".equals(scheme)) {
                    scheme = "http";
                } else if ("wss".equals(scheme)) {
                    scheme = "https";
                }
                yield requestTarget.scheme(scheme).encode(true);
            }
            case RequestTargetForm.AUTHORITY_FORM -> {
                Integer port = requestTarget.port();
                if (port == null) {
                    port = HttpClientHelper.getDefaultPort(requestTarget.scheme());
                }
                yield requestTarget.host() + ":" + port;
            }
            case RequestTargetForm.ASTERISK_FORM -> "*";
        };
    }
}

