/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http2.hpack;

import cool.scx.http.x.http2.hpack.HPACKHuffmanCodec;
import cool.scx.http.x.http2.hpack.HPACKStaticTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HPACKDecoder {
    private static final int MAX_DYNAMIC_TABLE_SIZE = 4096;
    private final List<String[]> dynamicTable = new ArrayList<String[]>();

    private static int[] decodeInteger(byte[] data, int startIndex, int prefixBits) {
        int prefixMask = (1 << prefixBits) - 1;
        int index = startIndex;
        int value = data[index] & prefixMask;
        ++index;
        if (value == prefixMask) {
            int b;
            int m = 0;
            do {
                b = data[index] & 0xFF;
                value += (b & 0x7F) << m;
                m += 7;
                ++index;
            } while ((b & 0x80) != 0);
        }
        return new int[]{value, index};
    }

    public Map<String, String> decode(byte[] data) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        int index = 0;
        while (index < data.length) {
            int firstByte = data[index] & 0xFF;
            ++index;
            if ((firstByte & 0x80) != 0) {
                int[] result = HPACKDecoder.decodeInteger(data, index - 1, 7);
                int headerIndex = result[0];
                index = result[1];
                String[] header = this.getHeaderFromIndex(headerIndex);
                headersMap.put(header[0], header[1]);
                continue;
            }
            if ((firstByte & 0x40) != 0) {
                this.processLiteralHeader(data, firstByte, 6, headersMap, true, index - 1);
                index = this.processLiteralHeader(data, firstByte, 6, headersMap, true, index - 1);
                continue;
            }
            if ((firstByte & 0xF0) == 0) {
                index = this.processLiteralHeader(data, firstByte, 4, headersMap, false, index - 1);
                continue;
            }
            if ((firstByte & 0xF0) == 16) {
                index = this.processLiteralHeader(data, firstByte, 4, headersMap, false, index - 1);
                continue;
            }
            throw new IllegalArgumentException("Unsupported header field type");
        }
        return headersMap;
    }

    private int processLiteralHeader(byte[] data, int firstByte, int prefixBits, Map<String, String> headers, boolean addToTable, int startIndex) {
        String name;
        int[] nameIndexResult = HPACKDecoder.decodeInteger(data, startIndex, prefixBits);
        int nameIndex = nameIndexResult[0];
        int index = nameIndexResult[1];
        if (nameIndex == 0) {
            boolean huffmanName = (data[index] & 0x80) != 0;
            int[] nameLenResult = HPACKDecoder.decodeInteger(data, index, 7);
            int nameLen = nameLenResult[0];
            index = nameLenResult[1];
            name = this.decodeString(data, index, nameLen, huffmanName);
            index += nameLen;
        } else {
            String[] header = this.getHeaderFromIndex(nameIndex);
            name = header[0];
        }
        boolean huffmanValue = (data[index] & 0x80) != 0;
        int[] valueLenResult = HPACKDecoder.decodeInteger(data, index, 7);
        int valueLen = valueLenResult[0];
        index = valueLenResult[1];
        String value = this.decodeString(data, index, valueLen, huffmanValue);
        index += valueLen;
        headers.put(name, value);
        if (addToTable) {
            this.addToDynamicTable(new String[]{name, value});
        }
        return index;
    }

    private String decodeString(byte[] data, int start, int length, boolean huffman) {
        byte[] bytes = new byte[length];
        System.arraycopy(data, start, bytes, 0, length);
        return huffman ? HPACKHuffmanCodec.HPACK_HUFFMAN_CODEC.decode(bytes) : new String(bytes);
    }

    private void addToDynamicTable(String[] header) {
        String[] removed;
        this.dynamicTable.add(0, header);
        int entrySize = header[0].length() + header[1].length() + 32;
        for (int currentSize = this.dynamicTable.stream().mapToInt(e -> e[0].length() + e[1].length() + 32).sum(); currentSize > 4096; currentSize -= removed[0].length() + removed[1].length() + 32) {
            removed = this.dynamicTable.remove(this.dynamicTable.size() - 1);
        }
    }

    private String[] getHeaderFromIndex(int index) {
        if (index <= HPACKStaticTable.STATIC_TABLE.size()) {
            return HPACKStaticTable.get(index);
        }
        int dynamicIndex = index - HPACKStaticTable.STATIC_TABLE.size() - 1;
        if (dynamicIndex < 0 || dynamicIndex >= this.dynamicTable.size()) {
            throw new IllegalArgumentException("Invalid header index: " + index);
        }
        return this.dynamicTable.get(dynamicIndex);
    }
}

