/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x;

import cool.scx.http.ScxHttpClientRequest;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.method.HttpMethod;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.sender.HttpSendException;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.version.HttpVersion;
import cool.scx.http.x.HttpClient;
import cool.scx.http.x.HttpClientOptions;
import cool.scx.http.x.http1.Http1ClientConnection;
import cool.scx.http.x.http1.Http1ClientRequest;
import cool.scx.http.x.http1.request_line.RequestTargetForm;
import cool.scx.http.x.http2.Http2ClientConnection;
import cool.scx.tcp.ScxTCPSocket;
import java.io.IOException;

public class HttpClientRequest
implements Http1ClientRequest {
    private final HttpClient httpClient;
    private final HttpClientOptions options;
    protected HttpVersion version;
    protected ScxHttpMethod method;
    protected ScxURIWritable uri;
    protected ScxHttpHeadersWritable headers;
    protected RequestTargetForm requestTargetForm;

    public HttpClientRequest(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.options = httpClient.options();
        this.version = null;
        this.method = HttpMethod.GET;
        this.uri = ScxURI.of();
        this.headers = ScxHttpHeaders.of();
        this.requestTargetForm = RequestTargetForm.ORIGIN_FORM;
    }

    public ScxHttpClientResponse send(MediaWriter writer) throws HttpSendException {
        ScxTCPSocket tcpSocket;
        try {
            tcpSocket = this.httpClient.createTCPSocket((ScxURI)this.uri, this.getApplicationProtocols());
        }
        catch (IOException e) {
            throw new HttpSendException("\u521b\u5efa\u8fde\u63a5\u5931\u8d25 !!!", (Throwable)e);
        }
        boolean useHttp2 = false;
        if (tcpSocket.isTLS()) {
            String applicationProtocol = tcpSocket.tlsManager().getApplicationProtocol();
            useHttp2 = "h2".equals(applicationProtocol);
        }
        if (useHttp2) {
            return new Http2ClientConnection(tcpSocket, this.options).sendRequest(this, writer).waitResponse();
        }
        if (!tcpSocket.isTLS() && this.options.proxy() != null && this.options.proxy().enabled()) {
            this.requestTargetForm = RequestTargetForm.ABSOLUTE_FORM;
        }
        try {
            return new Http1ClientConnection(tcpSocket, this.options).sendRequest(this, writer).waitResponse();
        }
        catch (IOException e) {
            throw new HttpSendException("\u53d1\u9001 HTTP \u8bf7\u6c42\u5931\u8d25 !!!", (Throwable)e);
        }
    }

    private String[] getApplicationProtocols() {
        if (this.options.enableHttp2()) {
            return new String[]{HttpVersion.HTTP_1_1.alpnValue(), HttpVersion.HTTP_2.alpnValue()};
        }
        return new String[]{HttpVersion.HTTP_1_1.alpnValue()};
    }

    public HttpVersion version() {
        return this.version;
    }

    public ScxHttpMethod method() {
        return this.method;
    }

    public ScxURIWritable uri() {
        return this.uri;
    }

    public ScxHttpHeadersWritable headers() {
        return this.headers;
    }

    public ScxHttpClientRequest version(HttpVersion version) {
        this.version = version;
        return this;
    }

    public ScxHttpClientRequest method(ScxHttpMethod method) {
        this.method = method;
        return this;
    }

    public ScxHttpClientRequest uri(ScxURI uri) {
        this.uri = ScxURI.of((ScxURI)uri);
        return this;
    }

    public ScxHttpClientRequest headers(ScxHttpHeaders headers) {
        this.headers = ScxHttpHeaders.of((ScxHttpHeaders)headers);
        return this;
    }

    @Override
    public RequestTargetForm requestTargetForm() {
        return this.requestTargetForm;
    }

    @Override
    public HttpClientRequest requestTargetForm(RequestTargetForm requestTargetForm) {
        this.requestTargetForm = requestTargetForm;
        return this;
    }
}

