/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.bytes.ByteReader;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.bytes.supplier.InputStreamByteSupplier;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.x.HttpClientOptions;
import cool.scx.http.x.http1.Http1ClientConnectionOptions;
import cool.scx.http.x.http1.Http1ClientRequest;
import cool.scx.http.x.http1.Http1ClientResponse;
import cool.scx.http.x.http1.Http1Helper;
import cool.scx.http.x.http1.Http1Reader;
import cool.scx.http.x.http1.NoCloseOutputStream;
import cool.scx.http.x.http1.chunked.HttpChunkedOutputStream;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.transfer_encoding.TransferEncoding;
import cool.scx.http.x.http1.request_line.Http1RequestLine;
import cool.scx.http.x.http1.status_line.Http1StatusLine;
import cool.scx.tcp.ScxTCPSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class Http1ClientConnection {
    public final ScxTCPSocket tcpSocket;
    public final ByteReader dataReader;
    public final OutputStream dataWriter;
    public final Http1ClientConnectionOptions options;

    public Http1ClientConnection(ScxTCPSocket tcpSocket, HttpClientOptions options) {
        this.tcpSocket = tcpSocket;
        this.dataReader = new ByteReader((ByteSupplier)new InputStreamByteSupplier(tcpSocket.inputStream()));
        this.dataWriter = new NoCloseOutputStream(tcpSocket.outputStream());
        this.options = options.http1ConnectionOptions();
    }

    public Http1ClientConnection sendRequest(Http1ClientRequest request, MediaWriter writer) throws IOException {
        Http1Headers headers = new Http1Headers((ScxHttpHeaders)request.headers());
        long expectedLength = writer.beforeWrite((ScxHttpHeadersWritable)headers, (ScxHttpHeaders)ScxHttpHeaders.of());
        Http1RequestLine requestLine = new Http1RequestLine(request.method(), (ScxURI)request.uri());
        String requestLineStr = requestLine.encode(request.requestTargetForm());
        if (!headers.contains((ScxHttpHeaderName)HttpFieldName.HOST)) {
            Integer port = request.uri().port();
            if (port != null) {
                headers.set((ScxHttpHeaderName)HttpFieldName.HOST, request.uri().host() + ":" + port);
            } else {
                headers.set((ScxHttpHeaderName)HttpFieldName.HOST, request.uri().host());
            }
        }
        if (expectedLength < 0L) {
            if (headers.contentLength() == null) {
                headers.transferEncoding(TransferEncoding.CHUNKED);
            }
        } else if (expectedLength > 0L) {
            if (headers.transferEncoding() != TransferEncoding.CHUNKED) {
                headers.contentLength(expectedLength);
            }
        } else {
            boolean hasBody = Http1Helper.checkRequestHasBody(request.method());
            if (hasBody && headers.transferEncoding() != TransferEncoding.CHUNKED) {
                headers.contentLength(expectedLength);
            }
        }
        String requestHeaderStr = headers.encode();
        String h = requestLineStr + "\r\n" + requestHeaderStr + "\r\n";
        this.dataWriter.write(h.getBytes(StandardCharsets.UTF_8));
        boolean useChunkedTransfer = headers.transferEncoding() == TransferEncoding.CHUNKED;
        OutputStream out = useChunkedTransfer ? new HttpChunkedOutputStream(this.dataWriter) : this.dataWriter;
        writer.write(out);
        return this;
    }

    public ScxHttpClientResponse waitResponse() {
        Http1StatusLine statusLine = Http1Reader.readStatusLine(this.dataReader, this.options.maxStatusLineSize());
        Http1Headers headers = Http1Reader.readHeaders(this.dataReader, this.options.maxHeaderSize());
        InputStream bodyInputStream = Http1Reader.readBodyInputStream(headers, this.dataReader, this.options.maxPayloadSize());
        return new Http1ClientResponse(statusLine, headers, bodyInputStream);
    }
}

