/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.common.util.StringUtils;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.method.HttpMethod;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.peer_info.PeerInfo;
import cool.scx.http.peer_info.PeerInfoWritable;
import cool.scx.http.status.HttpStatus;
import cool.scx.http.status.ScxHttpStatus;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.headers.upgrade.ScxUpgrade;
import cool.scx.http.x.http1.request_line.Http1RequestLine;
import cool.scx.io.io_stream.StreamClosedException;
import cool.scx.tcp.ScxTCPSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class Http1Helper {
    public static final byte[] CONTINUE_100 = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    public static final byte[] CRLF_BYTES = "\r\n".getBytes();
    public static final byte[] CRLF_CRLF_BYTES = "\r\n\r\n".getBytes();
    public static final byte[] CHUNKED_END_BYTES = "0\r\n\r\n".getBytes();

    public static ScxUpgrade checkUpgradeRequest(Http1RequestLine requestLine, Http1Headers headers) {
        return requestLine.method() == HttpMethod.GET && headers.connection() == Connection.UPGRADE ? headers.upgrade() : null;
    }

    public static void sendContinue100(OutputStream out) throws IOException {
        out.write(CONTINUE_100);
    }

    public static void consumeInputStream(InputStream inputStream) {
        try (InputStream inputStream2 = inputStream;){
            inputStream.transferTo(OutputStream.nullOutputStream());
        }
        catch (StreamClosedException | IOException throwable) {
            // empty catch block
        }
    }

    public static PeerInfoWritable getRemotePeer(ScxTCPSocket tcpSocket) {
        InetSocketAddress address = tcpSocket.remoteAddress();
        return PeerInfo.of().address((SocketAddress)address).host(address.getHostString()).port(address.getPort());
    }

    public static PeerInfoWritable getLocalPeer(ScxTCPSocket tcpSocket) {
        InetSocketAddress address = tcpSocket.localAddress();
        return PeerInfo.of().address((SocketAddress)address).host(address.getHostString()).port(address.getPort());
    }

    public static void validateHost(ScxHttpHeadersWritable headers) {
        List all = headers.getAll((Object)HttpFieldName.HOST);
        int size = all.size();
        if (size == 0) {
            throw new BadRequestException("HOST header is empty");
        }
        if (size > 1) {
            throw new BadRequestException("HOST header contains more than one value");
        }
        String hostValue = (String)all.get(0);
        if (StringUtils.isBlank((String)hostValue)) {
            throw new BadRequestException("HOST header is empty");
        }
    }

    public static boolean checkResponseHasBody(ScxHttpStatus status) {
        return HttpStatus.SWITCHING_PROTOCOLS != status && HttpStatus.NO_CONTENT != status && HttpStatus.NOT_MODIFIED != status;
    }

    public static boolean checkRequestHasBody(ScxHttpMethod method) {
        return HttpMethod.GET != method;
    }

    public static ScxURI inferURI(ScxURI requestLineTarget, ScxHttpHeaders headers, ScxTCPSocket tcpSocket) {
        ScxURIWritable uri = ScxURI.of((ScxURI)requestLineTarget);
        if (uri.scheme() != null) {
            return uri;
        }
        if (tcpSocket.isTLS()) {
            uri.scheme("https");
        } else {
            uri.scheme("http");
        }
        String host = (String)headers.get((Object)HttpFieldName.HOST);
        if (host != null) {
            ScxURI authority = ScxURI.ofAuthority((String)host);
            uri.host(authority.host()).port(authority.port());
        } else {
            InetSocketAddress localAddress = tcpSocket.localAddress();
            uri.host(localAddress.getHostString()).port(Integer.valueOf(localAddress.getPort()));
        }
        return uri;
    }
}

