/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.http.x.http1.Http1UpgradeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Http1ServerConnectionOptions {
    private int maxRequestLineSize;
    private int maxHeaderSize;
    private long maxPayloadSize;
    private boolean autoRespond100Continue;
    private boolean validateHost;
    private List<Http1UpgradeHandler> upgradeHandlerList;

    public Http1ServerConnectionOptions() {
        this.maxRequestLineSize = 65536;
        this.maxHeaderSize = 131072;
        this.maxPayloadSize = 0x1000000L;
        this.autoRespond100Continue = true;
        this.validateHost = true;
        this.upgradeHandlerList = new ArrayList<Http1UpgradeHandler>();
    }

    public Http1ServerConnectionOptions(Http1ServerConnectionOptions oldOptions) {
        this.maxRequestLineSize(oldOptions.maxRequestLineSize());
        this.maxHeaderSize(oldOptions.maxHeaderSize());
        this.maxPayloadSize(oldOptions.maxPayloadSize());
        this.autoRespond100Continue(oldOptions.autoRespond100Continue());
        this.validateHost(oldOptions.validateHost());
        this.upgradeHandlerList(oldOptions.upgradeHandlerList());
    }

    public int maxRequestLineSize() {
        return this.maxRequestLineSize;
    }

    public Http1ServerConnectionOptions maxRequestLineSize(int maxRequestLineSize) {
        this.maxRequestLineSize = maxRequestLineSize;
        return this;
    }

    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public Http1ServerConnectionOptions maxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public long maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public Http1ServerConnectionOptions maxPayloadSize(long maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
        return this;
    }

    public boolean autoRespond100Continue() {
        return this.autoRespond100Continue;
    }

    public Http1ServerConnectionOptions autoRespond100Continue(boolean autoRespond100Continue) {
        this.autoRespond100Continue = autoRespond100Continue;
        return this;
    }

    public boolean validateHost() {
        return this.validateHost;
    }

    public Http1ServerConnectionOptions validateHost(boolean validateHost) {
        this.validateHost = validateHost;
        return this;
    }

    public List<Http1UpgradeHandler> upgradeHandlerList() {
        return this.upgradeHandlerList;
    }

    public Http1ServerConnectionOptions upgradeHandlerList(List<Http1UpgradeHandler> upgradeHandlerList) {
        this.upgradeHandlerList = upgradeHandlerList;
        return this;
    }

    public Http1ServerConnectionOptions addUpgradeHandler(Http1UpgradeHandler ... upgradeHandlerList) {
        Collections.addAll(this.upgradeHandlerList, upgradeHandlerList);
        return this;
    }
}

