/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.chunked;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.ByteReader;
import cool.scx.bytes.exception.ByteSupplierException;
import cool.scx.bytes.exception.NoMatchFoundException;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.exception.ContentTooLargeException;

public class HttpChunkedDataSupplier
implements ByteSupplier {
    private final ByteReader dataReader;
    private final long maxLength;
    private long position;
    private boolean isFinished;

    public HttpChunkedDataSupplier(ByteReader dataReader) {
        this(dataReader, Long.MAX_VALUE);
    }

    public HttpChunkedDataSupplier(ByteReader dataReader, long maxLength) {
        this.dataReader = dataReader;
        this.maxLength = maxLength;
        this.position = 0L;
        this.isFinished = false;
    }

    public ByteChunk get() throws ByteSupplierException {
        int chunkLength;
        if (this.isFinished) {
            return null;
        }
        byte[] chunkLengthBytes = this.dataReader.readUntil("\r\n".getBytes());
        String chunkLengthStr = new String(chunkLengthBytes);
        try {
            chunkLength = Integer.parseUnsignedInt(chunkLengthStr, 16);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("\u9519\u8bef\u7684\u5206\u5757\u957f\u5ea6 !!!" + chunkLengthStr);
        }
        this.checkMaxPayload(chunkLength);
        if (chunkLength == 0) {
            byte[] endBytes;
            try {
                endBytes = this.dataReader.readUntil("\r\n".getBytes());
            }
            catch (NoMatchFoundException e) {
                throw new BadRequestException("\u9519\u8bef\u7684\u7ec8\u7ed3\u5206\u5757, \u7ec8\u7ed3\u5757\u4e0d\u5b8c\u6574: \u7f3a\u5c11 \\r\\n !!!");
            }
            if (endBytes.length != 0) {
                throw new BadRequestException("\u9519\u8bef\u7684\u7ec8\u7ed3\u5206\u5757, \u5e94\u4e3a\u7a7a\u5757\u4f46\u53d1\u73b0\u4e86\u5185\u5bb9 !!!");
            }
            this.isFinished = true;
            return null;
        }
        byte[] nextChunkData = this.dataReader.read(chunkLength);
        this.dataReader.skip(2L);
        return new ByteChunk(nextChunkData);
    }

    public void checkMaxPayload(int chunkLength) {
        if (this.position + (long)chunkLength > this.maxLength) {
            throw new ContentTooLargeException();
        }
        this.position += (long)chunkLength;
    }
}

