/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.fixed_length;

import cool.scx.bytes.ByteChunk;
import cool.scx.bytes.ByteReader;
import cool.scx.bytes.consumer.ByteChunkByteConsumer;
import cool.scx.bytes.consumer.ByteConsumer;
import cool.scx.bytes.exception.NoMoreDataException;
import cool.scx.bytes.supplier.ByteSupplier;

public class FixedLengthDataSupplier
implements ByteSupplier {
    private final ByteReader dataReader;
    private long remaining;

    public FixedLengthDataSupplier(ByteReader dataReader, long maxLength) {
        this.dataReader = dataReader;
        this.remaining = maxLength;
    }

    public ByteChunk get() {
        if (this.remaining <= 0L) {
            return null;
        }
        try {
            ByteChunkByteConsumer consumer = new ByteChunkByteConsumer();
            this.dataReader.read((ByteConsumer)consumer, this.remaining, 1L);
            ByteChunk byteChunk = consumer.getByteChunk();
            this.remaining -= (long)byteChunk.length;
            return byteChunk;
        }
        catch (NoMoreDataException e) {
            return null;
        }
    }
}

