/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http2;

public enum Http2FrameType {
    DATA(0),
    HEADERS(1),
    PRIORITY(2),
    RST_STREAM(3),
    SETTINGS(4),
    PUSH_PROMISE(5),
    PING(6),
    GOAWAY(7),
    WINDOW_UPDATE(8),
    CONTINUATION(9);

    private static final Http2FrameType[] MAP;
    private final byte code;

    private Http2FrameType(int code) {
        this.code = (byte)code;
    }

    private static Http2FrameType[] initMap() {
        Http2FrameType[] values;
        Http2FrameType[] m = new Http2FrameType[10];
        Http2FrameType[] http2FrameTypeArray = values = Http2FrameType.values();
        int n = http2FrameTypeArray.length;
        for (int i = 0; i < n; ++i) {
            Http2FrameType v;
            m[v.code] = v = http2FrameTypeArray[i];
        }
        return m;
    }

    public static Http2FrameType of(int code) {
        if (code < 0 || code > 9) {
            throw new IllegalArgumentException("Invalid Http2FrameType : " + code);
        }
        Http2FrameType c = MAP[code];
        if (c == null) {
            throw new IllegalArgumentException("Invalid Http2FrameType : " + code);
        }
        return c;
    }

    public static Http2FrameType find(int code) {
        if (code < 0 || code > 9) {
            return null;
        }
        return MAP[code];
    }

    public int code() {
        return this.code;
    }

    static {
        MAP = Http2FrameType.initMap();
    }
}

