/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http2;

import cool.scx.bytes.ByteReader;
import cool.scx.bytes.supplier.BufferedInputStreamByteSupplier;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.functional.ScxConsumer;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.error_handler.ScxHttpServerErrorHandler;
import cool.scx.http.x.HttpServerOptions;
import cool.scx.http.x.http2.Http2FrameHeader;
import cool.scx.http.x.http2.Http2FrameType;
import cool.scx.http.x.http2.Http2Helper;
import cool.scx.http.x.http2.Http2SettingsHelper;
import cool.scx.http.x.http2.State;
import cool.scx.http.x.http2.hpack.HPACKDecoder;
import cool.scx.tcp.ScxTCPSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;

public class Http2ServerConnection {
    private static final System.Logger LOGGER = System.getLogger(Http2ServerConnection.class.getName());
    private final ScxTCPSocket tcpSocket;
    private final HttpServerOptions options;
    private final ScxConsumer<ScxHttpServerRequest, ?> requestHandler;
    private final ScxHttpServerErrorHandler errorHandler;
    private final ByteReader dataReader;
    private final OutputStream dataWriter;
    private final HPACKDecoder hpackDecoder;
    private State state;

    public Http2ServerConnection(ScxTCPSocket tcpSocket, HttpServerOptions options, ScxConsumer<ScxHttpServerRequest, ?> requestHandler, ScxHttpServerErrorHandler errorHandler) {
        this.tcpSocket = tcpSocket;
        this.options = options;
        this.requestHandler = requestHandler;
        this.errorHandler = errorHandler;
        this.dataReader = new ByteReader((ByteSupplier)new BufferedInputStreamByteSupplier(this.tcpSocket.inputStream()));
        this.dataWriter = this.tcpSocket.outputStream();
        this.hpackDecoder = new HPACKDecoder();
    }

    public void start() {
        try {
            this.readPreface();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("\u65b0\u8fde\u63a5");
        try {
            while (true) {
                Http2FrameHeader frame = this.readFrameHeader();
                this.handleFrameHeader(frame);
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "\u5904\u7406\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            try {
                this.tcpSocket.close();
            }
            catch (IOException e2) {
                LOGGER.log(System.Logger.Level.TRACE, "\u5173\u95ed Socket \u65f6\u53d1\u751f\u9519\u8bef\uff01", (Throwable)e2);
            }
            return;
        }
    }

    private void readPreface() throws IOException {
        byte[] preface = this.dataReader.read(Http2Helper.HTTP2_CONNECTION_PREFACE.length);
        if (Arrays.compare(preface, Http2Helper.HTTP2_CONNECTION_PREFACE) != 0) {
            throw new IllegalStateException("Invalid HTTP/2 connection preface: \n");
        }
    }

    private Http2FrameHeader readFrameHeader() throws IOException {
        byte[] data = this.dataReader.read(9);
        return Http2FrameHeader.of(data);
    }

    private void handleFrameHeader(Http2FrameHeader frameHeader) throws IOException {
        switch (frameHeader.type()) {
            case DATA: {
                this.doData();
                break;
            }
            case HEADERS: {
                this.doHeaders(frameHeader);
                break;
            }
            case PRIORITY: {
                this.doPriority();
                break;
            }
            case RST_STREAM: {
                this.doRstStream();
                break;
            }
            case SETTINGS: {
                this.doSettings(frameHeader);
                break;
            }
            case PUSH_PROMISE: {
                this.doPushPromise();
                break;
            }
            case PING: {
                this.doPing();
                break;
            }
            case GOAWAY: {
                this.doGoaway();
                break;
            }
            case WINDOW_UPDATE: {
                this.doWindowUpdate(frameHeader);
                break;
            }
            case CONTINUATION: {
                this.doContinuation();
                break;
            }
            default: {
                this.doUnknown();
            }
        }
    }

    private void doData() {
    }

    private void doUnknown() {
    }

    private void doContinuation() {
    }

    private void doWindowUpdate(Http2FrameHeader frameHeader) {
        byte[] payload = this.dataReader.read(frameHeader.length());
        if (payload.length != 4) {
            throw new RuntimeException("WINDOW_UPDATE frame must be 4 bytes, but payload length is " + payload.length);
        }
        int windowSizeIncrement = (payload[0] & 0xFF) << 24 | (payload[1] & 0xFF) << 16 | (payload[2] & 0xFF) << 8 | payload[3] & 0xFF;
        if (windowSizeIncrement == 0) {
            throw new RuntimeException("WINDOW_UPDATE increment must be positive but received " + windowSizeIncrement);
        }
        if (frameHeader.streamId() == 0) {
            // empty if block
        }
    }

    private void doGoaway() {
    }

    private void doPing() {
    }

    private void doPushPromise() {
    }

    private void doSettings(Http2FrameHeader frameHeader) {
        if (frameHeader.streamId() != 0) {
            throw new RuntimeException("Settings must use stream ID 0, but use " + frameHeader.streamId());
        }
        byte[] payload = this.dataReader.read(frameHeader.length());
        Map<Integer, Integer> integerIntegerMap = Http2SettingsHelper.readHttp2Settings(payload);
        System.out.println(integerIntegerMap);
        this.sendSettingsAck();
    }

    private void doRstStream() {
    }

    private void doPriority() {
    }

    private void doHeaders(Http2FrameHeader frameHeader) throws IOException {
        byte[] headerBlockFragment;
        byte[] payload = this.dataReader.read(frameHeader.length());
        boolean endHeaders = (frameHeader.flags() & 4) != 0;
        boolean padded = (frameHeader.flags() & 8) != 0;
        boolean priority = (frameHeader.flags() & 0x20) != 0;
        int offset = 0;
        if (padded) {
            int padLength = payload[offset] & 0xFF;
            ++offset;
        }
        if (priority) {
            int streamDependency = (payload[offset] & 0x7F) << 24 | (payload[offset + 1] & 0xFF) << 16 | (payload[offset + 2] & 0xFF) << 8 | payload[offset + 3] & 0xFF;
            boolean exclusive = (payload[offset] & 0x80) != 0;
            int weight = payload[offset + 4] & 0xFF;
            offset += 5;
            System.out.println("Priority information: streamDependency=" + streamDependency + ", exclusive=" + exclusive + ", weight=" + weight);
        }
        if (padded) {
            int padLength = payload[frameHeader.length() - 1] & 0xFF;
            headerBlockFragment = Arrays.copyOfRange(payload, offset, payload.length - padLength);
        } else {
            headerBlockFragment = Arrays.copyOfRange(payload, offset, payload.length);
        }
        Map<String, String> headers = this.hpackDecoder.decode(headerBlockFragment);
        System.out.println("Headers: " + String.valueOf(headers));
        if (!endHeaders) {
            this.readContinuationHeaders(frameHeader.streamId(), headers);
        }
    }

    private Map<String, String> decodeHeaders(byte[] headerBlockFragment) {
        return null;
    }

    private void readContinuationHeaders(int streamId, Map<String, String> headers) throws IOException {
        boolean endHeaders = false;
        while (!endHeaders) {
            Http2FrameHeader continuationFrameHeader = this.readFrameHeader();
            if (continuationFrameHeader.type() != Http2FrameType.CONTINUATION) {
                throw new RuntimeException("Expected CONTINUATION frame but got " + String.valueOf((Object)continuationFrameHeader.type()));
            }
            byte[] payload = this.dataReader.read(continuationFrameHeader.length());
            endHeaders = (continuationFrameHeader.flags() & 4) != 0;
            byte[] headerBlockFragment = Arrays.copyOfRange(payload, 0, payload.length);
            Map<String, String> decodedHeaders = this.decodeHeaders(headerBlockFragment);
            headers.putAll(decodedHeaders);
        }
    }

    private void sendSettingsAck() {
        try {
            byte[] ackFrame = new byte[9];
            ackFrame[3] = 4;
            ackFrame[4] = 1;
            this.dataWriter.write(ackFrame);
            this.dataWriter.flush();
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "\u53d1\u9001 ACK \u5e27\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }
}

