package cool.scx.http.x.http2.hpack;

import java.util.HashMap;
import java.util.Map;

/// HPACK 静态霍夫曼编码表, 取自 RFC 7541 附录 B.
///
/// @author scx567888
/// @version 0.0.1
public class HPACKHuffmanTable {

    public static final Map<Character, String> HPACK_HUFFMAN_TABLE = initTable();

    private static Map<Character, String> initTable() {
        //为了便于开发人员 维护编写成以下形式 
        var m = new HashMap<Integer, String>();
        m.put(0, "|11111111|11000");
        m.put(1, "|11111111|11111111|1011000");
        m.put(2, "|11111111|11111111|11111110|0010");
        m.put(3, "|11111111|11111111|11111110|0011");
        m.put(4, "|11111111|11111111|11111110|0100");
        m.put(5, "|11111111|11111111|11111110|0101");
        m.put(6, "|11111111|11111111|11111110|0110");
        m.put(7, "|11111111|11111111|11111110|0111");
        m.put(8, "|11111111|11111111|11111110|1000");
        m.put(9, "|11111111|11111111|11101010");
        m.put(10, "|11111111|11111111|11111111|111100");
        m.put(11, "|11111111|11111111|11111110|1001");
        m.put(12, "|11111111|11111111|11111110|1010");
        m.put(13, "|11111111|11111111|11111111|111101");
        m.put(14, "|11111111|11111111|11111110|1011");
        m.put(15, "|11111111|11111111|11111110|1100");
        m.put(16, "|11111111|11111111|11111110|1101");
        m.put(17, "|11111111|11111111|11111110|1110");
        m.put(18, "|11111111|11111111|11111110|1111");
        m.put(19, "|11111111|11111111|11111111|0000");
        m.put(20, "|11111111|11111111|11111111|0001");
        m.put(21, "|11111111|11111111|11111111|0010");
        m.put(22, "|11111111|11111111|11111111|111110");
        m.put(23, "|11111111|11111111|11111111|0011");
        m.put(24, "|11111111|11111111|11111111|0100");
        m.put(25, "|11111111|11111111|11111111|0101");
        m.put(26, "|11111111|11111111|11111111|0110");
        m.put(27, "|11111111|11111111|11111111|0111");
        m.put(28, "|11111111|11111111|11111111|1000");
        m.put(29, "|11111111|11111111|11111111|1001");
        m.put(30, "|11111111|11111111|11111111|1010");
        m.put(31, "|11111111|11111111|11111111|1011");
        m.put(32, "|010100");                                      // ' '                   
        m.put(33, "|11111110|00");                                 // '!'                   
        m.put(34, "|11111110|01");                                 // '"'                   
        m.put(35, "|11111111|1010");                               // '#'                   
        m.put(36, "|11111111|11001");                              // '$'                   
        m.put(37, "|010101");                                      // '%'                   
        m.put(38, "|11111000");                                    // '&'                   
        m.put(39, "|11111111|010");                                // '''                   
        m.put(40, "|11111110|10");                                 // '('                   
        m.put(41, "|11111110|11");                                 // ')'                   
        m.put(42, "|11111001");                                    // '*'                   
        m.put(43, "|11111111|011");                                // '+'                   
        m.put(44, "|11111010");                                    // ','                   
        m.put(45, "|010110");                                      // '-'                   
        m.put(46, "|010111");                                      // '.'                   
        m.put(47, "|011000");                                      // '/'                   
        m.put(48, "|00000");                                       // '0'                   
        m.put(49, "|00001");                                       // '1'                   
        m.put(50, "|00010");                                       // '2'                   
        m.put(51, "|011001");                                      // '3'                   
        m.put(52, "|011010");                                      // '4'                   
        m.put(53, "|011011");                                      // '5'                   
        m.put(54, "|011100");                                      // '6'                   
        m.put(55, "|011101");                                      // '7'                   
        m.put(56, "|011110");                                      // '8'                   
        m.put(57, "|011111");                                      // '9'                   
        m.put(58, "|1011100");                                     // ':'                   
        m.put(59, "|11111011");                                    // ';'                   
        m.put(60, "|11111111|1111100");                            // '<'                   
        m.put(61, "|100000");                                      // '='                   
        m.put(62, "|11111111|1011");                               // '>'                   
        m.put(63, "|11111111|00");                                 // '?'                   
        m.put(64, "|11111111|11010");                              // '@'                   
        m.put(65, "|100001");                                      // 'A'                   
        m.put(66, "|1011101");                                     // 'B'                   
        m.put(67, "|1011110");                                     // 'C'                   
        m.put(68, "|1011111");                                     // 'D'                   
        m.put(69, "|1100000");                                     // 'E'                   
        m.put(70, "|1100001");                                     // 'F'                   
        m.put(71, "|1100010");                                     // 'G'                   
        m.put(72, "|1100011");                                     // 'H'                   
        m.put(73, "|1100100");                                     // 'I'                   
        m.put(74, "|1100101");                                     // 'J'                   
        m.put(75, "|1100110");                                     // 'K'                   
        m.put(76, "|1100111");                                     // 'L'                   
        m.put(77, "|1101000");                                     // 'M'                   
        m.put(78, "|1101001");                                     // 'N'                   
        m.put(79, "|1101010");                                     // 'O'                   
        m.put(80, "|1101011");                                     // 'P'                   
        m.put(81, "|1101100");                                     // 'Q'                   
        m.put(82, "|1101101");                                     // 'R'                   
        m.put(83, "|1101110");                                     // 'S'                   
        m.put(84, "|1101111");                                     // 'T'                   
        m.put(85, "|1110000");                                     // 'U'                   
        m.put(86, "|1110001");                                     // 'V'                   
        m.put(87, "|1110010");                                     // 'W'                   
        m.put(88, "|11111100");                                    // 'X'                   
        m.put(89, "|1110011");                                     // 'Y'                   
        m.put(90, "|11111101");                                    // 'Z'                   
        m.put(91, "|11111111|11011");                              // '['                   
        m.put(92, "|11111111|11111110|000");                       // '\'                   
        m.put(93, "|11111111|11100");                              // ']'                   
        m.put(94, "|11111111|111100");                             // '^'                   
        m.put(95, "|100010");                                      // '_'                   
        m.put(96, "|11111111|1111101");                            // '`'                   
        m.put(97, "|00011");                                       // 'a'                   
        m.put(98, "|100011");                                      // 'b'                   
        m.put(99, "|00100");                                       // 'c'                   
        m.put(100, "|100100");                                     // 'd'                   
        m.put(101, "|00101");                                      // 'e'                   
        m.put(102, "|100101");                                     // 'f'                   
        m.put(103, "|100110");                                     // 'g'                   
        m.put(104, "|100111");                                     // 'h'                   
        m.put(105, "|00110");                                      // 'i'                   
        m.put(106, "|1110100");                                    // 'j'                   
        m.put(107, "|1110101");                                    // 'k'                   
        m.put(108, "|101000");                                     // 'l'                   
        m.put(109, "|101001");                                     // 'm'                   
        m.put(110, "|101010");                                     // 'n'                   
        m.put(111, "|00111");                                      // 'o'                   
        m.put(112, "|101011");                                     // 'p'                   
        m.put(113, "|1110110");                                    // 'q'                   
        m.put(114, "|101100");                                     // 'r'                   
        m.put(115, "|01000");                                      // 's'                   
        m.put(116, "|01001");                                      // 't'                   
        m.put(117, "|101101");                                     // 'u'                   
        m.put(118, "|1110111");                                    // 'v'                   
        m.put(119, "|1111000");                                    // 'w'                   
        m.put(120, "|1111001");                                    // 'x'                   
        m.put(121, "|1111010");                                    // 'y'                   
        m.put(122, "|1111011");                                    // 'z'                   
        m.put(123, "|11111111|1111110");                           // '{'                   
        m.put(124, "|11111111|100");                               // '|'                     
        m.put(125, "|11111111|111101");                            // '}'                     
        m.put(126, "|11111111|11101");                             // '~'                     
        m.put(127, "|11111111|11111111|11111111|1100");
        m.put(128, "|11111111|11111110|0110");
        m.put(129, "|11111111|11111111|010010");
        m.put(130, "|11111111|11111110|0111");
        m.put(131, "|11111111|11111110|1000");
        m.put(132, "|11111111|11111111|010011");
        m.put(133, "|11111111|11111111|010100");
        m.put(134, "|11111111|11111111|010101");
        m.put(135, "|11111111|11111111|1011001");
        m.put(136, "|11111111|11111111|010110");
        m.put(137, "|11111111|11111111|1011010");
        m.put(138, "|11111111|11111111|1011011");
        m.put(139, "|11111111|11111111|1011100");
        m.put(140, "|11111111|11111111|1011101");
        m.put(141, "|11111111|11111111|1011110");
        m.put(142, "|11111111|11111111|11101011");
        m.put(143, "|11111111|11111111|1011111");
        m.put(144, "|11111111|11111111|11101100");
        m.put(145, "|11111111|11111111|11101101");
        m.put(146, "|11111111|11111111|010111");
        m.put(147, "|11111111|11111111|1100000");
        m.put(148, "|11111111|11111111|11101110");
        m.put(149, "|11111111|11111111|1100001");
        m.put(150, "|11111111|11111111|1100010");
        m.put(151, "|11111111|11111111|1100011");
        m.put(152, "|11111111|11111111|1100100");
        m.put(153, "|11111111|11111110|11100");
        m.put(154, "|11111111|11111111|011000");
        m.put(155, "|11111111|11111111|1100101");
        m.put(156, "|11111111|11111111|011001");
        m.put(157, "|11111111|11111111|1100110");
        m.put(158, "|11111111|11111111|1100111");
        m.put(159, "|11111111|11111111|11101111");
        m.put(160, "|11111111|11111111|011010");
        m.put(161, "|11111111|11111110|11101");
        m.put(162, "|11111111|11111110|1001");
        m.put(163, "|11111111|11111111|011011");
        m.put(164, "|11111111|11111111|011100");
        m.put(165, "|11111111|11111111|1101000");
        m.put(166, "|11111111|11111111|1101001");
        m.put(167, "|11111111|11111110|11110");
        m.put(168, "|11111111|11111111|1101010");
        m.put(169, "|11111111|11111111|011101");
        m.put(170, "|11111111|11111111|011110");
        m.put(171, "|11111111|11111111|11110000");
        m.put(172, "|11111111|11111110|11111");
        m.put(173, "|11111111|11111111|011111");
        m.put(174, "|11111111|11111111|1101011");
        m.put(175, "|11111111|11111111|1101100");
        m.put(176, "|11111111|11111111|00000");
        m.put(177, "|11111111|11111111|00001");
        m.put(178, "|11111111|11111111|100000");
        m.put(179, "|11111111|11111111|00010");
        m.put(180, "|11111111|11111111|1101101");
        m.put(181, "|11111111|11111111|100001");
        m.put(182, "|11111111|11111111|1101110");
        m.put(183, "|11111111|11111111|1101111");
        m.put(184, "|11111111|11111110|1010");
        m.put(185, "|11111111|11111111|100010");
        m.put(186, "|11111111|11111111|100011");
        m.put(187, "|11111111|11111111|100100");
        m.put(188, "|11111111|11111111|1110000");
        m.put(189, "|11111111|11111111|100101");
        m.put(190, "|11111111|11111111|100110");
        m.put(191, "|11111111|11111111|1110001");
        m.put(192, "|11111111|11111111|11111000|00");
        m.put(193, "|11111111|11111111|11111000|01");
        m.put(194, "|11111111|11111110|1011");
        m.put(195, "|11111111|11111110|001");
        m.put(196, "|11111111|11111111|100111");
        m.put(197, "|11111111|11111111|1110010");
        m.put(198, "|11111111|11111111|101000");
        m.put(199, "|11111111|11111111|11110110|0");
        m.put(200, "|11111111|11111111|11111000|10");
        m.put(201, "|11111111|11111111|11111000|11");
        m.put(202, "|11111111|11111111|11111001|00");
        m.put(203, "|11111111|11111111|11111011|110");
        m.put(204, "|11111111|11111111|11111011|111");
        m.put(205, "|11111111|11111111|11111001|01");
        m.put(206, "|11111111|11111111|11110001");
        m.put(207, "|11111111|11111111|11110110|1");
        m.put(208, "|11111111|11111110|010");
        m.put(209, "|11111111|11111111|00011");
        m.put(210, "|11111111|11111111|11111001|10");
        m.put(211, "|11111111|11111111|11111100|000");
        m.put(212, "|11111111|11111111|11111100|001");
        m.put(213, "|11111111|11111111|11111001|11");
        m.put(214, "|11111111|11111111|11111100|010");
        m.put(215, "|11111111|11111111|11110010");
        m.put(216, "|11111111|11111111|00100");
        m.put(217, "|11111111|11111111|00101");
        m.put(218, "|11111111|11111111|11111010|00");
        m.put(219, "|11111111|11111111|11111010|01");
        m.put(220, "|11111111|11111111|11111111|1101");
        m.put(221, "|11111111|11111111|11111100|011");
        m.put(222, "|11111111|11111111|11111100|100");
        m.put(223, "|11111111|11111111|11111100|101");
        m.put(224, "|11111111|11111110|1100");
        m.put(225, "|11111111|11111111|11110011");
        m.put(226, "|11111111|11111110|1101");
        m.put(227, "|11111111|11111111|00110");
        m.put(228, "|11111111|11111111|101001");
        m.put(229, "|11111111|11111111|00111");
        m.put(230, "|11111111|11111111|01000");
        m.put(231, "|11111111|11111111|1110011");
        m.put(232, "|11111111|11111111|101010");
        m.put(233, "|11111111|11111111|101011");
        m.put(234, "|11111111|11111111|11110111|0");
        m.put(235, "|11111111|11111111|11110111|1");
        m.put(236, "|11111111|11111111|11110100");
        m.put(237, "|11111111|11111111|11110101");
        m.put(238, "|11111111|11111111|11111010|10");
        m.put(239, "|11111111|11111111|1110100");
        m.put(240, "|11111111|11111111|11111010|11");
        m.put(241, "|11111111|11111111|11111100|110");
        m.put(242, "|11111111|11111111|11111011|00");
        m.put(243, "|11111111|11111111|11111011|01");
        m.put(244, "|11111111|11111111|11111100|111");
        m.put(245, "|11111111|11111111|11111101|000");
        m.put(246, "|11111111|11111111|11111101|001");
        m.put(247, "|11111111|11111111|11111101|010");
        m.put(248, "|11111111|11111111|11111101|011");
        m.put(249, "|11111111|11111111|11111111|1110");
        m.put(250, "|11111111|11111111|11111101|100");
        m.put(251, "|11111111|11111111|11111101|101");
        m.put(252, "|11111111|11111111|11111101|110");
        m.put(253, "|11111111|11111111|11111101|111");
        m.put(254, "|11111111|11111111|11111110|000");
        m.put(255, "|11111111|11111111|11111011|10");
        m.put(256, "|11111111|11111111|11111111|111111");            //EOS

        var s = new HashMap<Character, String>();
        //最后的 256 我们丢弃
        for (int i = 0; i < 257; i = i + 1) {
            s.put((char) i, m.get(i));
        }
        return Map.copyOf(s); //转换为不可变的 map
    }

}
