/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x;

import cool.scx.http.ScxHttpClient;
import cool.scx.http.ScxHttpClientRequest;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.method.HttpMethod;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.status.HttpStatus;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.x.HttpClientHelper;
import cool.scx.http.x.HttpClientOptions;
import cool.scx.http.x.HttpClientRequest;
import cool.scx.http.x.http1.Http1ClientConnection;
import cool.scx.http.x.http1.request_line.RequestTargetForm;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.TCPClient;
import cool.scx.tcp.tls.TLS;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class HttpClient
implements ScxHttpClient {
    private final HttpClientOptions options;

    public HttpClient(HttpClientOptions options) {
        this.options = options;
    }

    public HttpClient() {
        this(new HttpClientOptions());
    }

    private static ScxTCPSocket configTLS(ScxTCPSocket tcpSocket, TLS tls, ScxURI uri, String ... applicationProtocols) throws IOException {
        try {
            tcpSocket.upgradeToTLS(tls);
        }
        catch (IOException e) {
            HttpClient.tryCloseSocket(tcpSocket, e);
            throw new IOException("\u5347\u7ea7\u5230 TLS \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
        tcpSocket.tlsManager().setUseClientMode(true);
        tcpSocket.tlsManager().setApplicationProtocols(applicationProtocols);
        tcpSocket.tlsManager().setServerNames(new String[]{uri.host()});
        try {
            tcpSocket.startHandshake();
        }
        catch (IOException e) {
            HttpClient.tryCloseSocket(tcpSocket, e);
            throw new IOException("\u5904\u7406 TLS \u63e1\u624b \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
        }
        return tcpSocket;
    }

    private static void tryCloseSocket(ScxTCPSocket tcpSocket, Exception e) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            e.addSuppressed(ex);
        }
    }

    public HttpClientOptions options() {
        return this.options;
    }

    public ScxTCPSocket createTCPSocket(ScxURI uri, String ... applicationProtocols) throws IOException {
        boolean withProxy;
        boolean isTLS = HttpClientHelper.checkIsTLS(uri);
        boolean bl = withProxy = this.options.proxy() != null && this.options.proxy().enabled();
        if (isTLS) {
            return withProxy ? this.createTLSTCPSocketWithProxy(uri, applicationProtocols) : this.createTLSTCPSocket(uri, applicationProtocols);
        }
        return withProxy ? this.createPlainTCPSocketWithProxy() : this.createPlainTCPSocket(uri);
    }

    public ScxTCPSocket createPlainTCPSocket(ScxURI uri) throws IOException {
        TCPClient tcpClient = new TCPClient();
        InetSocketAddress remoteAddress = HttpClientHelper.getRemoteAddress(uri);
        return tcpClient.connect((SocketAddress)remoteAddress, this.options.timeout());
    }

    public ScxTCPSocket createTLSTCPSocket(ScxURI uri, String ... applicationProtocols) throws IOException {
        TCPClient tcpClient = new TCPClient();
        InetSocketAddress remoteAddress = HttpClientHelper.getRemoteAddress(uri);
        ScxTCPSocket tcpSocket = tcpClient.connect((SocketAddress)remoteAddress, this.options.timeout());
        return HttpClient.configTLS(tcpSocket, this.options.tls(), uri, applicationProtocols);
    }

    public ScxTCPSocket createPlainTCPSocketWithProxy() throws IOException {
        TCPClient tcpClient = new TCPClient();
        SocketAddress remoteAddress = this.options.proxy().proxyAddress();
        return tcpClient.connect(remoteAddress, this.options.timeout());
    }

    public ScxTCPSocket createTLSTCPSocketWithProxy(ScxURI uri, String ... applicationProtocols) throws IOException {
        ScxTCPSocket tcpSocket = this.createPlainTCPSocketWithProxy();
        ScxHttpClientResponse proxyResponse = new Http1ClientConnection(tcpSocket, this.options).sendRequest((HttpClientRequest)((ScxHttpClientRequest)new HttpClientRequest(this).requestTargetForm(RequestTargetForm.AUTHORITY_FORM).method((ScxHttpMethod)HttpMethod.CONNECT).addHeader("proxy-connection", new String[]{"keep-alive"})).uri(uri), (MediaWriter)EmptyWriter.EMPTY_WRITER).waitResponse();
        if (proxyResponse.status() != HttpStatus.OK) {
            throw new RuntimeException("\u4ee3\u7406\u8fde\u63a5\u5931\u8d25 :" + String.valueOf(proxyResponse.status()));
        }
        return HttpClient.configTLS(tcpSocket, TLS.ofTrustAny(), uri, applicationProtocols);
    }

    public HttpClientRequest request() {
        return new HttpClientRequest(this);
    }
}

