/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x;

import cool.scx.http.uri.ScxURI;
import java.net.InetSocketAddress;

public class HttpClientHelper {
    public static boolean checkIsTLS(ScxURI uri) {
        String scheme;
        return switch (scheme = uri.scheme().toLowerCase()) {
            case "http", "ws" -> false;
            case "https", "wss" -> true;
            default -> throw new IllegalArgumentException("Unsupported scheme: " + uri.scheme());
        };
    }

    public static InetSocketAddress getRemoteAddress(ScxURI uri) {
        String host = uri.host();
        Integer port = uri.port();
        if (port == null) {
            port = HttpClientHelper.getDefaultPort(uri.scheme());
        }
        return new InetSocketAddress(host, (int)port);
    }

    public static int getDefaultPort(String scheme) {
        return switch (scheme = scheme.toLowerCase()) {
            case "http", "ws" -> 80;
            case "https", "wss" -> 443;
            default -> throw new IllegalArgumentException("Unsupported scheme: " + scheme);
        };
    }
}

