/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x;

import cool.scx.function.ConsumerX;
import cool.scx.http.ScxHttpServer;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.error_handler.ScxHttpServerErrorHandler;
import cool.scx.http.version.HttpVersion;
import cool.scx.http.x.HttpServerOptions;
import cool.scx.http.x.http1.Http1ServerConnection;
import cool.scx.http.x.http2.Http2ServerConnection;
import cool.scx.tcp.ScxTCPServer;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.TCPServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class HttpServer
implements ScxHttpServer {
    private static final System.Logger LOGGER = System.getLogger(HttpServer.class.getName());
    private final HttpServerOptions options;
    private final ScxTCPServer tcpServer;
    private ConsumerX<ScxHttpServerRequest, ?> requestHandler;
    private ScxHttpServerErrorHandler errorHandler;

    public HttpServer(HttpServerOptions options) {
        this.options = options;
        this.tcpServer = new TCPServer(options.tcpServerOptions());
        this.tcpServer.onConnect(this::handle);
    }

    public HttpServer() {
        this(new HttpServerOptions());
    }

    private static void tryCloseSocket(ScxTCPSocket tcpSocket, Exception e) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            e.addSuppressed(ex);
        }
    }

    private void handle(ScxTCPSocket tcpSocket) {
        if (this.options.tls() != null) {
            try {
                tcpSocket.upgradeToTLS(this.options.tls());
            }
            catch (IOException e) {
                HttpServer.tryCloseSocket(tcpSocket, e);
                LOGGER.log(System.Logger.Level.TRACE, "\u5347\u7ea7\u5230 TLS \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                return;
            }
            tcpSocket.tlsManager().setUseClientMode(false);
            tcpSocket.tlsManager().setHandshakeApplicationProtocolSelector((scxTLSManager, protocols) -> this.options.enableHttp2() && protocols.contains(HttpVersion.HTTP_2.alpnValue()) ? HttpVersion.HTTP_2.alpnValue() : (protocols.contains(HttpVersion.HTTP_1_1.alpnValue()) ? HttpVersion.HTTP_1_1.alpnValue() : null));
            try {
                tcpSocket.startHandshake();
            }
            catch (IOException e) {
                HttpServer.tryCloseSocket(tcpSocket, e);
                LOGGER.log(System.Logger.Level.TRACE, "\u5904\u7406 TLS \u63e1\u624b \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                return;
            }
        }
        boolean useHttp2 = false;
        if (tcpSocket.isTLS()) {
            String applicationProtocol = tcpSocket.tlsManager().getApplicationProtocol();
            useHttp2 = HttpVersion.HTTP_2.alpnValue().equals(applicationProtocol);
        }
        if (useHttp2) {
            new Http2ServerConnection(tcpSocket, this.options, this.requestHandler, this.errorHandler).start();
        } else {
            new Http1ServerConnection(tcpSocket, this.options, this.requestHandler, this.errorHandler).start();
        }
    }

    public ScxHttpServer onRequest(ConsumerX<ScxHttpServerRequest, ?> requestHandler) {
        this.requestHandler = requestHandler;
        return this;
    }

    public ScxHttpServer onError(ScxHttpServerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public void start(SocketAddress localAddress) throws IOException {
        this.tcpServer.start(localAddress);
    }

    public void stop() {
        this.tcpServer.stop();
    }

    public InetSocketAddress localAddress() {
        return this.tcpServer.localAddress();
    }

    public HttpServerOptions options() {
        return this.options;
    }
}

