/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x;

import cool.scx.http.x.http1.Http1ServerConnectionOptions;
import cool.scx.http.x.http1.Http1UpgradeHandler;
import cool.scx.tcp.TCPServerOptions;
import cool.scx.tcp.tls.TLS;
import java.util.List;

public class HttpServerOptions {
    private final TCPServerOptions tcpServerOptions;
    private final Http1ServerConnectionOptions http1ConnectionOptions;
    private TLS tls;
    private boolean enableHttp2;

    public HttpServerOptions() {
        this.tcpServerOptions = new TCPServerOptions();
        this.http1ConnectionOptions = new Http1ServerConnectionOptions();
        this.tls = null;
        this.enableHttp2 = false;
    }

    public HttpServerOptions(HttpServerOptions oldOptions) {
        this.tcpServerOptions = new TCPServerOptions(oldOptions.tcpServerOptions());
        this.http1ConnectionOptions = new Http1ServerConnectionOptions(oldOptions.http1ConnectionOptions());
        this.tls(oldOptions.tls());
        this.enableHttp2(oldOptions.enableHttp2());
    }

    TCPServerOptions tcpServerOptions() {
        return this.tcpServerOptions;
    }

    public Http1ServerConnectionOptions http1ConnectionOptions() {
        return this.http1ConnectionOptions;
    }

    public int maxRequestLineSize() {
        return this.http1ConnectionOptions.maxRequestLineSize();
    }

    public HttpServerOptions maxRequestLineSize(int maxRequestLineSize) {
        this.http1ConnectionOptions.maxRequestLineSize(maxRequestLineSize);
        return this;
    }

    public int maxHeaderSize() {
        return this.http1ConnectionOptions.maxHeaderSize();
    }

    public HttpServerOptions maxHeaderSize(int maxHeaderSize) {
        this.http1ConnectionOptions.maxHeaderSize(maxHeaderSize);
        return this;
    }

    public long maxPayloadSize() {
        return this.http1ConnectionOptions.maxPayloadSize();
    }

    public HttpServerOptions maxPayloadSize(long maxPayloadSize) {
        this.http1ConnectionOptions.maxPayloadSize(maxPayloadSize);
        return this;
    }

    public boolean autoRespond100Continue() {
        return this.http1ConnectionOptions.autoRespond100Continue();
    }

    public HttpServerOptions autoRespond100Continue(boolean autoRespond100Continue) {
        this.http1ConnectionOptions.autoRespond100Continue(autoRespond100Continue);
        return this;
    }

    public boolean validateHost() {
        return this.http1ConnectionOptions.validateHost();
    }

    public HttpServerOptions validateHost(boolean validateHost) {
        this.http1ConnectionOptions.validateHost(validateHost);
        return this;
    }

    public List<Http1UpgradeHandler> upgradeHandlerList() {
        return this.http1ConnectionOptions.upgradeHandlerList();
    }

    public HttpServerOptions upgradeHandlerList(List<Http1UpgradeHandler> upgradeHandlerList) {
        this.http1ConnectionOptions.upgradeHandlerList(upgradeHandlerList);
        return this;
    }

    public HttpServerOptions addUpgradeHandler(Http1UpgradeHandler ... upgradeHandlerList) {
        this.http1ConnectionOptions.addUpgradeHandler(upgradeHandlerList);
        return this;
    }

    public boolean enableHttp2() {
        return this.enableHttp2;
    }

    public HttpServerOptions enableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
        return this;
    }

    public int backlog() {
        return this.tcpServerOptions.backlog();
    }

    public HttpServerOptions backlog(int backlog) {
        this.tcpServerOptions.backlog(backlog);
        return this;
    }

    public TLS tls() {
        return this.tls;
    }

    public HttpServerOptions tls(TLS tls) {
        this.tls = tls;
        return this;
    }
}

