/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.bytes.ByteReader;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.bytes.supplier.InputStreamByteSupplier;
import cool.scx.function.ConsumerX;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.error_handler.DefaultHttpServerErrorHandler;
import cool.scx.http.error_handler.ErrorPhase;
import cool.scx.http.error_handler.ErrorPhaseHelper;
import cool.scx.http.error_handler.ScxHttpServerErrorHandler;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.x.HttpServerOptions;
import cool.scx.http.x.http1.AutoContinueInputStream;
import cool.scx.http.x.http1.CloseConnectionException;
import cool.scx.http.x.http1.Http1Helper;
import cool.scx.http.x.http1.Http1Reader;
import cool.scx.http.x.http1.Http1ServerRequest;
import cool.scx.http.x.http1.Http1UpgradeHandler;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.headers.expect.Expect;
import cool.scx.http.x.http1.headers.upgrade.ScxUpgrade;
import cool.scx.http.x.http1.request_line.Http1RequestLine;
import cool.scx.io.io_stream.NullCheckedInputStream;
import cool.scx.tcp.ScxTCPSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Http1ServerConnection {
    private static final System.Logger LOGGER = System.getLogger(Http1ServerConnection.class.getName());
    public final ScxTCPSocket tcpSocket;
    public final HttpServerOptions options;
    public final ConsumerX<ScxHttpServerRequest, ?> requestHandler;
    public final ScxHttpServerErrorHandler errorHandler;
    public final ByteReader dataReader;
    public final OutputStream dataWriter;
    private boolean running;

    public Http1ServerConnection(ScxTCPSocket tcpSocket, HttpServerOptions options, ConsumerX<ScxHttpServerRequest, ?> requestHandler, ScxHttpServerErrorHandler errorHandler) {
        this.tcpSocket = tcpSocket;
        this.options = options;
        this.requestHandler = requestHandler;
        this.errorHandler = errorHandler;
        this.dataReader = new ByteReader((ByteSupplier)new InputStreamByteSupplier(this.tcpSocket.inputStream()));
        this.dataWriter = this.tcpSocket.outputStream();
        this.running = true;
    }

    public void start() {
        while (this.running) {
            ScxHttpServerRequest request;
            try {
                request = this.readRequest();
            }
            catch (CloseConnectionException e) {
                this.stop();
                break;
            }
            catch (Throwable e) {
                this.handlerSystemException(e);
                break;
            }
            try {
                this._callRequestHandler(request);
            }
            catch (Throwable e) {
                this.handlerUserException(e, request);
            }
            finally {
                if (!this.running) continue;
                Http1Helper.consumeInputStream(request.body().inputStream());
            }
        }
    }

    private ScxHttpServerRequest readRequest() throws CloseConnectionException {
        ScxUpgrade upgrade;
        Http1RequestLine requestLine = Http1Reader.readRequestLine(this.dataReader, this.options.maxRequestLineSize());
        Http1Headers headers = Http1Reader.readHeaders(this.dataReader, this.options.maxHeaderSize());
        InputStream bodyInputStream = Http1Reader.readBodyInputStream(headers, this.dataReader, this.options.maxPayloadSize());
        if (this.options.validateHost()) {
            Http1Helper.validateHost(headers);
        }
        if (headers.expect() == Expect.CONTINUE) {
            if (this.options.autoRespond100Continue()) {
                try {
                    Http1Helper.sendContinue100(this.dataWriter);
                }
                catch (IOException e) {
                    throw new CloseConnectionException("Failed to write continue", e);
                }
            } else {
                bodyInputStream = new AutoContinueInputStream(bodyInputStream, this.dataWriter);
            }
        }
        if ((upgrade = Http1Helper.checkUpgradeRequest(requestLine, headers)) != null) {
            for (Http1UpgradeHandler upgradeHandler : this.options.upgradeHandlerList()) {
                boolean canHandle = upgradeHandler.canHandle(upgrade);
                if (!canHandle) continue;
                return upgradeHandler.createScxHttpServerRequest(this, requestLine, headers, bodyInputStream);
            }
        }
        return new Http1ServerRequest(this, requestLine, headers, bodyInputStream);
    }

    public void stop() {
        this.running = false;
    }

    public void close() throws IOException {
        this.stop();
        this.tcpSocket.close();
    }

    private void _callRequestHandler(ScxHttpServerRequest request) throws Throwable {
        if (this.requestHandler != null) {
            this.requestHandler.accept((Object)request);
        }
    }

    private void handlerSystemException(Throwable e) {
        Http1ServerRequest fakeRequest = new Http1ServerRequest(this, new Http1RequestLine(ScxHttpMethod.of((String)"unknown"), (ScxURI)ScxURI.of()), new Http1Headers().connection(Connection.CLOSE), (InputStream)new NullCheckedInputStream());
        this.handlerException(e, fakeRequest, ErrorPhase.SYSTEM);
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handlerUserException(Throwable e, ScxHttpServerRequest request) {
        this.handlerException(e, request, ErrorPhase.USER);
    }

    private void handlerException(Throwable e, ScxHttpServerRequest request, ErrorPhase errorPhase) {
        if (this.tcpSocket.isClosed()) {
            LOGGER.log(System.Logger.Level.ERROR, ErrorPhaseHelper.getErrorPhaseStr((ErrorPhase)errorPhase) + " \u53d1\u751f\u5f02\u5e38 !!!, \u56e0\u4e3a Socket \u5df2\u88ab\u5173\u95ed, \u6240\u4ee5\u9519\u8bef\u4fe1\u606f\u53ef\u80fd\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef !!!", e);
            return;
        }
        if (request.response().isSent()) {
            LOGGER.log(System.Logger.Level.ERROR, ErrorPhaseHelper.getErrorPhaseStr((ErrorPhase)errorPhase) + " \u53d1\u751f\u5f02\u5e38 !!!, \u56e0\u4e3a\u8bf7\u6c42\u5df2\u88ab\u76f8\u5e94, \u6240\u4ee5\u9519\u8bef\u4fe1\u606f\u53ef\u80fd\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef !!!", e);
            return;
        }
        try {
            if (this.errorHandler != null) {
                this.errorHandler.accept(e, request, errorPhase);
            } else {
                DefaultHttpServerErrorHandler.DEFAULT_HTTP_SERVER_ERROR_HANDLER.accept(e, request, errorPhase);
            }
        }
        catch (Exception ex) {
            e.addSuppressed(ex);
            LOGGER.log(System.Logger.Level.ERROR, ErrorPhaseHelper.getErrorPhaseStr((ErrorPhase)errorPhase) + " \u53d1\u751f\u5f02\u5e38 !!!, \u5c1d\u8bd5\u901a\u8fc7 \u9519\u8bef\u5904\u7406\u5668 \u54cd\u5e94\u7ed9\u5ba2\u6237\u7aef\u65f6\u53d1\u751f\u5f02\u5e38 !!!", e);
        }
    }

    public boolean running() {
        return this.running;
    }
}

