/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1;

import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.body.ScxHttpBody;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.method.ScxHttpMethod;
import cool.scx.http.peer_info.PeerInfo;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.version.HttpVersion;
import cool.scx.http.x.http1.Http1Body;
import cool.scx.http.x.http1.Http1Helper;
import cool.scx.http.x.http1.Http1ServerConnection;
import cool.scx.http.x.http1.Http1ServerResponse;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.request_line.Http1RequestLine;
import java.io.InputStream;

public class Http1ServerRequest
implements ScxHttpServerRequest {
    public final Http1ServerConnection connection;
    private final ScxHttpMethod method;
    private final ScxURI uri;
    private final HttpVersion version;
    private final Http1Headers headers;
    private final ScxHttpBody body;
    private final PeerInfo remotePeer;
    private final PeerInfo localPeer;
    private final Http1ServerResponse response;

    public Http1ServerRequest(Http1ServerConnection connection, Http1RequestLine requestLine, Http1Headers headers, InputStream bodyInputStream) {
        this.connection = connection;
        this.method = requestLine.method();
        this.uri = Http1Helper.inferURI(requestLine.requestTarget(), (ScxHttpHeaders)headers, connection.tcpSocket);
        this.version = requestLine.version();
        this.headers = headers;
        this.body = new Http1Body(bodyInputStream, this.headers);
        this.remotePeer = Http1Helper.getRemotePeer(connection.tcpSocket);
        this.localPeer = Http1Helper.getLocalPeer(connection.tcpSocket);
        this.response = new Http1ServerResponse(connection, this);
    }

    public Http1ServerResponse response() {
        return this.response;
    }

    public ScxHttpMethod method() {
        return this.method;
    }

    public ScxURI uri() {
        return this.uri;
    }

    public HttpVersion version() {
        return this.version;
    }

    public Http1Headers headers() {
        return this.headers;
    }

    public ScxHttpBody body() {
        return this.body;
    }

    public PeerInfo remotePeer() {
        return this.remotePeer;
    }

    public PeerInfo localPeer() {
        return this.localPeer;
    }

    public boolean isKeepAlive() {
        return this.headers.connection() != Connection.CLOSE;
    }
}

