/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.chunked;

import cool.scx.http.x.http1.Http1Helper;
import java.io.IOException;
import java.io.OutputStream;

public class HttpChunkedOutputStream
extends OutputStream {
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final OutputStream out;

    public HttpChunkedOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.writeHexLength(len);
        this.out.write(Http1Helper.CRLF_BYTES);
        this.out.write(b, off, len);
        this.out.write(Http1Helper.CRLF_BYTES);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.write(Http1Helper.CHUNKED_END_BYTES);
        this.out.close();
    }

    private void writeHexLength(int value) throws IOException {
        byte[] bytes = new byte[8];
        int pos = 8;
        do {
            bytes[--pos] = HEX_DIGITS[value & 0xF];
        } while ((value >>>= 4) != 0);
        this.out.write(bytes, pos, 8 - pos);
    }

    public OutputStream outputStream() {
        return this.out;
    }
}

