/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.headers.connection;

import cool.scx.http.x.http1.headers.connection.ScxConnection;

public enum Connection implements ScxConnection
{
    KEEP_ALIVE("keep-alive"),
    CLOSE("close"),
    UPGRADE("upgrade");

    private final String value;

    private Connection(String value) {
        this.value = value;
    }

    public static Connection of(String v) {
        Connection h = Connection.find(v);
        if (h == null) {
            throw new IllegalArgumentException("Unknown connection : " + v);
        }
        return h;
    }

    public static Connection find(String v) {
        String v1;
        return switch (v1 = v.toLowerCase()) {
            case "keep-alive" -> KEEP_ALIVE;
            case "close" -> CLOSE;
            case "upgrade" -> UPGRADE;
            default -> null;
        };
    }

    @Override
    public String value() {
        return this.value;
    }
}

