/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.x.http1.status_line;

import cool.scx.http.version.HttpVersion;
import cool.scx.http.x.http1.request_line.InvalidHttpVersion;
import cool.scx.http.x.http1.status_line.Http1StatusLine;
import cool.scx.http.x.http1.status_line.InvalidHttpStatusException;
import cool.scx.http.x.http1.status_line.InvalidHttpStatusLineException;

public class Http1StatusLineHelper {
    public static Http1StatusLine parseStatusLine(String statusLineStr) throws InvalidHttpStatusLineException, InvalidHttpVersion, InvalidHttpStatusException {
        int code;
        String[] parts = statusLineStr.split(" ", 3);
        if (parts.length != 3) {
            throw new InvalidHttpStatusLineException(statusLineStr);
        }
        String versionStr = parts[0];
        String codeStr = parts[1];
        String reasonStr = parts[2];
        HttpVersion version = HttpVersion.find((String)versionStr);
        if (version != HttpVersion.HTTP_1_1) {
            throw new InvalidHttpVersion(versionStr);
        }
        try {
            code = Integer.parseInt(codeStr);
        }
        catch (NumberFormatException e) {
            throw new InvalidHttpStatusException(codeStr);
        }
        return new Http1StatusLine(version, code, reasonStr);
    }

    public static String encode(Http1StatusLine statusLine) {
        return statusLine.version().protocolVersion() + " " + statusLine.code() + " " + statusLine.reason();
    }
}

