/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import cool.scx.http.HttpFieldName;
import cool.scx.http.Parameters;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxHttpHeadersHelper;
import cool.scx.http.ScxHttpHeadersImpl;
import cool.scx.http.ScxHttpHeadersWritable;
import cool.scx.http.content_disposition.ContentDisposition;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.cookie.Cookie;
import cool.scx.http.cookie.Cookies;
import java.util.List;

public interface ScxHttpHeaders
extends Parameters<ScxHttpHeaderName, String> {
    public static ScxHttpHeadersWritable of() {
        return new ScxHttpHeadersImpl();
    }

    public static ScxHttpHeadersWritable of(String headerStr) {
        return ScxHttpHeadersHelper.parseHeaders(headerStr);
    }

    @Override
    default public String get(String name) {
        return (String)this.get(ScxHttpHeaderName.of(name));
    }

    @Override
    default public List<String> getAll(String name) {
        return this.getAll(ScxHttpHeaderName.of(name));
    }

    @Override
    default public boolean contains(String name) {
        return this.contains(ScxHttpHeaderName.of(name));
    }

    default public Cookies cookies() {
        return Cookies.of((String)this.get(HttpFieldName.COOKIE));
    }

    default public Cookies setCookies() {
        return Cookies.of((String[])this.getAll(HttpFieldName.SET_COOKIE).toArray(String[]::new));
    }

    default public ContentType contentType() {
        return ContentType.of((String)this.get(HttpFieldName.CONTENT_TYPE));
    }

    default public ContentDisposition contentDisposition() {
        return ContentDisposition.of((String)this.get(HttpFieldName.CONTENT_DISPOSITION));
    }

    default public Long contentLength() {
        String c = (String)this.get(HttpFieldName.CONTENT_LENGTH);
        return c != null ? Long.valueOf(Long.parseLong(c)) : null;
    }

    default public Cookie getCookie(String name) {
        return this.cookies().get(name);
    }

    default public Cookie getSetCookie(String name) {
        return this.setCookies().get(name);
    }

    default public String encode() {
        return ScxHttpHeadersHelper.encodeHeaders(this);
    }
}

